package com.instabug.apm.compose.compose_spans.model

import android.database.Cursor
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMComposeSpansEntry
import com.instabug.library.parse.Parser

class SpansCacheModelCursorParser : Parser<Cursor?, List<ComposeSpansCacheModel>?> {
    override fun parse(source: Cursor?): List<ComposeSpansCacheModel>? =
        source?.takeIf { it.moveToFirst() }?.let { cursor ->
            ArrayList<ComposeSpansCacheModel>().also { modelsList ->
                val nameColumnIndex = cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_NAME)
                val spansColumnIndex = cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_SPANS)
                val showAsScreenColumnIndex =
                    cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_SHOW_AS_SCREEN)
                val startTimestampMicrosColumnIndex =
                    cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_START_TIMESTAMP_MICROS)
                val durationMicrosColumnIndex =
                    cursor.getColumnIndex(APMComposeSpansEntry.COLUMN_DURATION_MICROS)
                do {
                    modelsList += ComposeSpansCacheModel(
                        name = cursor.getString(nameColumnIndex),
                        spansJsonString = cursor.getString(spansColumnIndex),
                        shouldShowAsScreen = cursor.getInt(showAsScreenColumnIndex) == 1,
                        startTimestampMicros = cursor.getLong(startTimestampMicrosColumnIndex),
                        durationMicros = cursor.getLong(durationMicrosColumnIndex)
                    )
                } while (cursor.moveToNext())
            }
        }


}