package com.instabug.apm.appflow.validate

import com.instabug.apm.appflow.log.logFlowNameIsNullOrEmpty
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.sanitization.Validator

class AppFlowNameValidator(
    private val logger: Logger
) : Validator<String?> {

    override fun isValid(item: String?): Boolean =
        (item?.trim()?.isNotEmpty() ?: false)
            .also (::logIfInvalid)

    private fun logIfInvalid(valid: Boolean) {
        takeUnless { valid }?.let { logger.logFlowNameIsNullOrEmpty() }
    }
}