package com.instabug.apm.appflow.validate

import com.instabug.apm.appflow.configuration.APP_FLOW_NAME_MAX_LENGTH
import com.instabug.apm.appflow.log.logFlowNameTruncated
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.sanitization.Sanitizer

class AppFlowNameSanitizer(
    private val logger: Logger
): Sanitizer<String?> {

    override fun sanitize(item: String?): String? =
        item?.trim()?.let { trimmedName ->
            trimmedName.takeIf { it.length <= APP_FLOW_NAME_MAX_LENGTH }
                ?: truncate(trimmedName)
        }

    private fun truncate(trimmedName: String) =
        trimmedName.substring(0, APP_FLOW_NAME_MAX_LENGTH).also {
            logger.logFlowNameTruncated(trimmedName)
        }
}