package com.instabug.apm.appflow.di

import com.instabug.apm.appStateDispacher.AppStateEventListener
import com.instabug.apm.appflow.model.AppFlowAttribute
import com.instabug.apm.appflow.usecases.UseCase
import com.instabug.apm.di.Provider
import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.model.TimeCaptureBoundModel
import com.instabug.apm.v3_session_data_readiness.APMSessionReadinessHandler
import com.instabug.library.core.eventbus.AppStateEvent
import com.instabug.library.model.common.Session
import java.util.concurrent.ExecutorService

class AppFlowApmSessionReadinessHandlerProvider : Provider<APMSessionReadinessHandler?> {
    override fun invoke(): APMSessionReadinessHandler? =
        AppFlowServiceLocator.appFlowApmSessionReadinessHandler
}

class AppFlowAppStateEventListenerProvider : Provider<AppStateEventListener> {
    override fun invoke(): AppStateEventListener =
        AppFlowServiceLocator.appFlowAppStateEventListener
}

class AppFlowBackgroundUseCaseProvider : Provider<UseCase<Unit, Unit>?> {
    override fun invoke(): UseCase<Unit, Unit>? =
        AppFlowServiceLocator.appFlowBackgroundUseCase
}

class AppFlowExecutorProvider : Provider<ExecutorService> {
    override fun invoke(): ExecutorService = AppFlowServiceLocator.appFlowExecutor
}

class AppFlowForegroundUseCaseProvider :
    Provider<UseCase<Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>, Unit>?> {
    override fun invoke(): UseCase<Pair<AppStateEvent.ForegroundAppStateEvent, AppStateEvent.BackgroundAppStateEvent?>, Unit>? =
        AppFlowServiceLocator.appFlowForegroundUseCase
}

class AppFlowNewSessionUseCaseProvider : Provider<UseCase<Pair<Session, Session?>, Unit>?> {
    override fun invoke(): UseCase<Pair<Session, Session?>, Unit>? =
        AppFlowServiceLocator.newSessionUseCase
}

class AppStateProvider : Provider<AppStateEvent?> {
    override fun invoke(): AppStateEvent? =
        ServiceLocator.getAppStateEventDispatcher().currentAppStateEvent
}

class DisableUseCaseProvider : Provider<UseCase<Unit, Unit>?> {
    override fun invoke(): UseCase<Unit, Unit>? =
        AppFlowServiceLocator.disableUseCase
}

class EndFlowUseCaseProvider : Provider<UseCase<TimeCaptureBoundModel<String?>, Unit>?> {
    override fun invoke(): UseCase<TimeCaptureBoundModel<String?>, Unit>? =
        AppFlowServiceLocator.endFlowUseCase
}

class SetFlowAttributeUseCaseProvider :
    Provider<UseCase<TimeCaptureBoundModel<AppFlowAttribute>, Unit>?> {
    override fun invoke(): UseCase<TimeCaptureBoundModel<AppFlowAttribute>, Unit>? =
        AppFlowServiceLocator.addAttributeUseCase
}

class StartFlowUseCaseProvider : Provider<UseCase<TimeCaptureBoundModel<String?>, Unit>?> {

    override fun invoke(): UseCase<TimeCaptureBoundModel<String?>, Unit>? =
        AppFlowServiceLocator.startFlowUseCase
}

class AppFlowAppLaunchUseCaseProvider : Provider<UseCase<Unit, Unit>?> {
    override fun invoke(): UseCase<Unit, Unit>? = AppFlowServiceLocator.appFLowAppLaunchUseCase
}