package com.instabug.apm.util

import android.util.DisplayMetrics
import kotlin.math.pow
import kotlin.math.sqrt

/**
 * Calculate the percentage of the diagonal line from fromWidthPx, fromHeightPx to the diagonal
 * line of screenDisplayMetrics
 */
fun rectangleDiagonalPercentage(
    fromWidthPx: Double,
    fromHeightPx: Double,
    screenDisplayMetrics: DisplayMetrics
): Double = rectangleDiagonalPercentage(
    fromWidthPx,
    fromHeightPx,
    screenDisplayMetrics.widthPixels.toDouble(),
    screenDisplayMetrics.heightPixels.toDouble()
)

/**
 * Calculate the square of the percentage of the diagonal line from fromWidthPx, fromHeightPx to the diagonal
 * line of screenDisplayMetrics
 */
fun rectangleDiagonalPercentageSquared(
    fromWidthPx: Double,
    fromHeightPx: Double,
    screenDisplayMetrics: DisplayMetrics
): Double = rectangleDiagonalPercentageSquared(
    fromWidthPx,
    fromHeightPx,
    screenDisplayMetrics.widthPixels.toDouble(),
    screenDisplayMetrics.heightPixels.toDouble()
)

/**
 * Calculate the percentage of the diagonal line from fromWidthPx, fromHeightPx to the diagonal
 * line of toWidthPx, toHeightPx
 */
fun rectangleDiagonalPercentage(
    fromWidth: Double,
    fromHeight: Double,
    toWidth: Double,
    toHeight: Double
): Double {
    return sqrt(
        rectangleDiagonalPercentageSquared(
            fromWidth,
            fromHeight,
            toWidth,
            toHeight
        )
    )
}

/**
 * Calculate the square of the percentage of the diagonal line from fromWidthPx, fromHeightPx to the diagonal
 * line of toWidthPx, toHeightPx
 */
fun rectangleDiagonalPercentageSquared(
    fromWidth: Double,
    fromHeight: Double,
    toWidth: Double,
    toHeight: Double
): Double {
    val fromDiagonalSquared = rectangleDiagonalSquared(fromWidth, fromHeight)
    val toDiagonalSquared = rectangleDiagonalSquared(toWidth, toHeight)
    return fromDiagonalSquared / toDiagonalSquared
}

/**
 * Calculate the square of the diagonal of a rectangle
 */
fun rectangleDiagonalSquared(width: Double, height: Double): Double =
    width.pow(2) + height.pow(2)

/**
 * Calculate the diagonal of a rectangle
 */
fun rectangleDiagonal(width: Double, height: Double): Double =
    sqrt(rectangleDiagonalSquared(width, height))
