package com.instabug.apm.handler.uitrace.uiloading;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.constants.UiLoadingMetric;
import com.instabug.apm.model.EventTimeMetricCapture;

public interface UiLoadingMetricHandler {

    /**
     * collect activity lifecycle event with it's timestamp, to be used in ScreenLoading metrics
     * @param activityEvent ActivityEvent to be collected
     * @param timeMetric Captured time metrics of the event
     */
    void addActivityEvent(
            @UiLoadingMetric.ActivityEvents int activityEvent,
            @NonNull EventTimeMetricCapture timeMetric
    );

    /**
     * Report that custom endScreenLoading event has been reported
     * @param timeMetric captured time metric of the event
     */
    void onScreenLoadingEnded(EventTimeMetricCapture timeMetric);

    /**
     * Returns a valid UiLoading model that represents the collected metrics, or null if the model
     * was invalid
     */
    @Nullable
    UiLoadingModel getUiLoadingModel();

    boolean hasEventNeverBeenReportedBefore(@UiLoadingMetric.ActivityEvents int eventIndex);
}
