package com.instabug.apm.compose.compose_spans.model

import com.instabug.apm.model.EventTimeMetricCapture

class ComposeSpansModel(
    val composableName: String,
    val shouldShowAsScreen: Boolean,
    val startTimestampMicros: Long
) {
    val events: Array<EventTimeMetricCapture?> =
        Array(ComposeSpanEventId.count - 1) { null }

    fun isValid() = events.none { it == null }

    operator fun set(@ComposeSpanEventId index: Int, value: EventTimeMetricCapture) {
        if (index >= 0 && index < events.size) {
            events[index] = value
        }
    }
}