package com.instabug.apm.appflow.usecases

import com.instabug.apm.appflow.handler.AppFlowHandler
import com.instabug.apm.appflow.model.AppFlowEndReason
import com.instabug.apm.di.Provider
import com.instabug.library.core.eventbus.AppStateEvent

class RefreshBackgroundFlowUseCase(
    private val appStateProvider: Provider<AppStateEvent?>,
    private val handler: AppFlowHandler
) : UseCase<Long, Boolean?> {
    override fun invoke(param: Long): Boolean? = appStateProvider().let { currentAppState ->
        if (currentAppState is AppStateEvent.BackgroundAppStateEvent) {
            handler.endActiveFlowsWithReason(
                currentAppState.timeStampMillis,
                param,
                AppFlowEndReason.ABANDONMENT
            )
        } else {
            false
        }
    }
}