package com.instabug.apm.appflow.map

import android.content.ContentValues
import com.instabug.apm.appflow.model.AppFlowAttributeInsertionCacheModel
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmAppFlowTableAttributeEntry
import com.instabug.library.map.Mapper

class AppFlowAttributeContentValuesMapper : Mapper<AppFlowAttributeInsertionCacheModel, ContentValues> {

    override fun map(from: AppFlowAttributeInsertionCacheModel): ContentValues =
        ContentValues().apply {
            put(ApmAppFlowTableAttributeEntry.COLUMN_FLOW_ID, from.flowId)
            put(ApmAppFlowTableAttributeEntry.COLUMN_KEY, from.key)
            put(ApmAppFlowTableAttributeEntry.COLUMN_VALUE, from.value)
        }
}