package com.instabug.apm.appflow.configuration

import com.instabug.apm.configuration.ConfigurationHandler
import com.instabug.apm.logger.APMLogger
import com.instabug.library.util.extenstions.runOrLogError
import org.json.JSONObject

class AppFlowConfigurationHandler(
    private val configurationProvider: AppFlowConfigurationProvider
) : ConfigurationHandler {
    override fun handleConfigurations(configsJson: JSONObject?) {
        configsJson?.runOrLogError {
            if (has(APP_FLOWS_ROOT_FLAG)) parseAppFlowConfigs()
            else handleNullConfigurationObject()
        }
    }

    private fun JSONObject.parseAppFlowConfigs() {
        optJSONObject(APP_FLOWS_ROOT_FLAG)?.run {
            optBoolean(APP_FLOWS_FEATURE_ENABLED, APP_FLOW_FEATURE_ENABLED_DEFAULT).let {
                configurationProvider.featureEnabled = it
                if (!it) reset() else cacheAppFlowConfigs()
            }
        }
    }

    private fun JSONObject.cacheAppFlowConfigs() {
        configurationProvider.run {
            attributesEnabled =
                optBoolean(APP_FLOW_ATTRIBUTES_ENABLED, APP_FLOW_ATTRIBUTES_ENABLED_DEFAULT)
            requestLimit = optInt(APP_FLOWS_REQUEST_LIMIT, APP_FLOW_REQUEST_LIMIT_DEFAULT)
            storeLimit = optInt(APP_FLOWS_STORE_LIMIT, APP_FLOW_STORE_LIMIT_DEFAULT)
            attributesStoreLimit =
                optInt(APP_FLOW_ATTRIBUTES_STORE_LIMIT, APP_FLOW_ATTRIBUTES_STORE_LIMIT_DEFAULT)
            idlingTimeThresholdMs = optInt(
                APP_FLOWS_IDLING_TIME_THRESHOLD_MS,
                APP_FLOW_IDLING_TIME_THRESHOLD_MS_DEFAULT
            )
        }
    }

    private fun handleNullConfigurationObject() {
        APMLogger.logSDKProtected("Can't parse app flow configurations, object is null.")
        reset()
    }

    override fun reset() = configurationProvider.reset()
}