package com.instabug.apm.networkinterception.cp

import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.networkinterception.APMNetworkLogWrapper

fun APMNetworkLogWrapper.populateExternalTraceAttributes(
    attributes: APMCPNetworkLog.W3CExternalTraceAttributes?,
    configsProvider: APMConfigurationProvider
) {
    attributes ?: return
    isW3CTraceIdCaptured = attributes.isCaptured
    generatedW3CPid = attributes.pid
    generatedW3CTimestampSeconds = attributes.timestampSeconds
    fullyGeneratedW3CTraceId = attributes.fullyGeneratedTrace
    syncableGeneratedW3CTraceId = attributes.fullyGeneratedTrace
        ?.takeIf { configsProvider.isAttachingGeneratedW3CExternalTraceIdEnabled }
    syncableCapturedW3CTraceId = attributes.fullyCapturedTrace
        ?.takeIf { configsProvider.isAttachingCapturedW3CExternalTraceIdEnabled }
}