package com.instabug.apm.handler.attributes;

import com.instabug.apm.attributes.listeners.OnNetworkTraceListener;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class NetworkTraceAttributesHandlerImpl implements NetworkTraceAttributesHandler {
    @Nullable
    private List<OnNetworkTraceListener> networkTraceAttributesAction;

    @Override
    public void add(@NonNull OnNetworkTraceListener listener) {
        if (networkTraceAttributesAction == null) {
            networkTraceAttributesAction = new ArrayList<>();
        }
        networkTraceAttributesAction.add(listener);
    }

    @Override
    @Nullable
    public List<OnNetworkTraceListener> getAll() {
        return networkTraceAttributesAction;
    }

    @Override
    public void remove(@NonNull OnNetworkTraceListener listener) {
        if (networkTraceAttributesAction != null) {
            networkTraceAttributesAction.remove(listener);
        }
    }
}
