/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.webview_trace.util;

import android.util.DisplayMetrics;
import com.instabug.apm.di.Provider;
import com.instabug.apm.util.SizeUtilKt;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.library.diagnostics.IBGDiagnostics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/instabug/apm/webview/webview_trace/util/WebViewSizeEventResolver;", "", "screenDisplayMetricProvider", "Lcom/instabug/apm/di/Provider;", "Landroid/util/DisplayMetrics;", "configurations", "Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;", "(Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;)V", "isFullScreen", "", "widthPx", "", "heightPx", "(II)Ljava/lang/Boolean;", "instabug-apm_defaultUiRelease"})
public final class WebViewSizeEventResolver {
    @NotNull
    private final Provider<DisplayMetrics> screenDisplayMetricProvider;
    @NotNull
    private final WebViewTraceConfigurationProvider configurations;

    public WebViewSizeEventResolver(@NotNull Provider<DisplayMetrics> provider, @NotNull WebViewTraceConfigurationProvider webViewTraceConfigurationProvider) {
        Intrinsics.checkNotNullParameter(provider, (String)"screenDisplayMetricProvider");
        Intrinsics.checkNotNullParameter((Object)webViewTraceConfigurationProvider, (String)"configurations");
        this.screenDisplayMetricProvider = provider;
        this.configurations = webViewTraceConfigurationProvider;
    }

    @Nullable
    public final Boolean isFullScreen(int n, int n2) {
        Object object;
        boolean bl = SizeUtilKt.rectangleDiagonalPercentage(n, n2, ((WebViewSizeEventResolver)object).screenDisplayMetricProvider.invoke()) > (double)((WebViewSizeEventResolver)object).configurations.getPartialViewPercentage();
        try {
            object = bl;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal((Throwable)exception, (String)"failed to resolve WebView size category");
            object = null;
        }
        return object;
    }
}

