/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.webview.webview_trace.handler;

import com.instabug.apm.di.Provider;
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceHandler;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceModelWrapper;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceRepository;
import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel;
import com.instabug.apm.webview.webview_trace.model.WebViewTraceModel;
import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent;
import com.instabug.apm.webview.webview_trace.model.event.WebViewTraceInitiationEvent;
import com.instabug.library.map.Mapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 (2\u00020\u0001:\u0001(BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0016\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u001c\u0010 \u001a\u00020\u00122\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u000bH\u0002J \u0010%\u001a\u00020\u0012*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J(\u0010&\u001a\u00020\u0012*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010'\u001a\u00020\u0012*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceRepositoryImpl;", "Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceRepository;", "configurations", "Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;", "handler", "Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceHandler;", "modelWrapperProvider", "Lcom/instabug/apm/di/Provider;", "Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceModelWrapper;", "mapper", "Lcom/instabug/library/map/Mapper;", "Lcom/instabug/apm/webview/webview_trace/model/WebViewTraceModel;", "Lcom/instabug/apm/webview/webview_trace/model/WebViewCacheModel;", "traces", "", "", "(Lcom/instabug/apm/webview/webview_trace/configuration/WebViewTraceConfigurationProvider;Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceHandler;Lcom/instabug/apm/di/Provider;Lcom/instabug/library/map/Mapper;Ljava/util/Map;)V", "checkAndHandleCreationEvent", "", "event", "Lcom/instabug/apm/webview/webview_trace/model/event/WebViewEvent;", "webViewTraceId", "checkAndHandleTerminationEvent", "enabled", "", "handleEvent", "isWebViewSizeResolved", "mapTraceModeToCacheModelAndUITraceIdPair", "Lkotlin/Pair;", "webViewTraceModel", "onUiTraceEnded", "traceId", "save", "modelPair", "shouldCollectVitals", "webViewSizeIsSupported", "it", "createTrace", "handleTraceEvent", "terminateTrace", "Companion", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nWebViewTraceRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewTraceRepositoryImpl.kt\ncom/instabug/apm/webview/webview_trace/handler/WebViewTraceRepositoryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n766#3:115\n857#3,2:116\n1549#3:118\n1620#3,3:119\n1855#3,2:122\n*S KotlinDebug\n*F\n+ 1 WebViewTraceRepositoryImpl.kt\ncom/instabug/apm/webview/webview_trace/handler/WebViewTraceRepositoryImpl\n*L\n92#1:115\n92#1:116,2\n93#1:118\n93#1:119,3\n94#1:122,2\n*E\n"})
public final class WebViewTraceRepositoryImpl
implements WebViewTraceRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebViewTraceConfigurationProvider configurations;
    @NotNull
    private final WebViewTraceHandler handler;
    @NotNull
    private final Provider<WebViewTraceModelWrapper> modelWrapperProvider;
    @NotNull
    private final Mapper<WebViewTraceModel, WebViewCacheModel> mapper;
    @NotNull
    private final Map<Long, WebViewTraceModelWrapper> traces;

    public WebViewTraceRepositoryImpl(@NotNull WebViewTraceConfigurationProvider webViewTraceConfigurationProvider, @NotNull WebViewTraceHandler webViewTraceHandler, @NotNull Provider<WebViewTraceModelWrapper> provider, @NotNull Mapper<WebViewTraceModel, WebViewCacheModel> mapper, @NotNull Map<Long, WebViewTraceModelWrapper> map) {
        Intrinsics.checkNotNullParameter((Object)webViewTraceConfigurationProvider, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)webViewTraceHandler, (String)"handler");
        Intrinsics.checkNotNullParameter(provider, (String)"modelWrapperProvider");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(map, (String)"traces");
        this.configurations = webViewTraceConfigurationProvider;
        this.handler = webViewTraceHandler;
        this.modelWrapperProvider = provider;
        this.mapper = mapper;
        this.traces = map;
    }

    private final void checkAndHandleTerminationEvent(WebViewEvent webViewEvent, long l) {
        if (webViewEvent.shouldTerminateCurrentTrace()) {
            WebViewTraceRepositoryImpl webViewTraceRepositoryImpl = this;
            webViewTraceRepositoryImpl.terminateTrace(webViewTraceRepositoryImpl.traces, l);
        }
    }

    private final void checkAndHandleCreationEvent(WebViewEvent webViewEvent, long l) {
        if (webViewEvent instanceof WebViewTraceInitiationEvent && ((WebViewTraceInitiationEvent)((Object)webViewEvent)).getShouldInitiateNewTrace()) {
            WebViewTraceRepositoryImpl webViewTraceRepositoryImpl = this;
            webViewTraceRepositoryImpl.createTrace(webViewTraceRepositoryImpl.traces, l);
        }
    }

    private final void terminateTrace(Map<Long, WebViewTraceModelWrapper> map, long l) {
        Object object = map.get(l);
        if (object != null && (object = object.getTraceModel()) != null) {
            if (!object.isValid()) {
                object = null;
            }
            if (object != null) {
                if (!this.webViewSizeIsSupported((WebViewTraceModel)object)) {
                    object = null;
                }
                if (object != null && (object = this.mapTraceModeToCacheModelAndUITraceIdPair((WebViewTraceModel)object)) != null) {
                    this.save((Pair<WebViewCacheModel, Long>)object);
                }
            }
        }
        map.remove(l);
    }

    private final boolean webViewSizeIsSupported(WebViewTraceModel webViewTraceModel) {
        return this.configurations.getPartialViewEnabled() || Intrinsics.areEqual((Object)webViewTraceModel.isFullScreen(), (Object)Boolean.TRUE);
    }

    private final Pair<WebViewCacheModel, Long> mapTraceModeToCacheModelAndUITraceIdPair(WebViewTraceModel webViewTraceModel) {
        Pair pair;
        WebViewCacheModel webViewCacheModel = (WebViewCacheModel)((WebViewTraceRepositoryImpl)((Object)webViewCacheModel)).mapper.map((Object)webViewTraceModel);
        if (webViewCacheModel != null) {
            Pair pair2;
            pair = pair2;
            pair2 = new Pair((Object)webViewCacheModel, (Object)webViewTraceModel.getUiTraceId());
        } else {
            pair = null;
        }
        return pair;
    }

    private final void save(Pair<WebViewCacheModel, Long> pair) {
        this.handler.save((WebViewCacheModel)pair.getFirst(), ((Number)pair.getSecond()).longValue());
    }

    private final void createTrace(Map<Long, WebViewTraceModelWrapper> map, long l) {
        if (!map.containsKey(l) && (this = ((WebViewTraceRepositoryImpl)this).modelWrapperProvider.invoke()) != null) {
            map.put(l, (WebViewTraceModelWrapper)this);
        }
    }

    private final void handleTraceEvent(Map<Long, WebViewTraceModelWrapper> object, long l, WebViewEvent webViewEvent) {
        if ((object = object.get(l)) != null && (object = ((WebViewTraceModelWrapper)object).handleEvent(webViewEvent)) != null) {
            this.handleEvent(l, (WebViewEvent)object);
        }
    }

    private final boolean enabled() {
        boolean bl = this.configurations.getEnabled();
        if (!bl) {
            this.traces.clear();
        }
        return bl;
    }

    @Override
    public void handleEvent(long l, @NotNull WebViewEvent webViewEvent) {
        Intrinsics.checkNotNullParameter((Object)webViewEvent, (String)"event");
        if (this.enabled() && webViewEvent.getCopyCount() < 5) {
            WebViewTraceRepositoryImpl webViewTraceRepositoryImpl = this;
            this.checkAndHandleTerminationEvent(webViewEvent, l);
            webViewTraceRepositoryImpl.checkAndHandleCreationEvent(webViewEvent, l);
            webViewTraceRepositoryImpl.handleTraceEvent(webViewTraceRepositoryImpl.traces, l, webViewEvent);
        }
    }

    @Override
    public void onUiTraceEnded(long l) {
        if (this.enabled()) {
            ArrayList<Long> arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3 = arrayList2;
            arrayList2 = new ArrayList();
            for (Object t : this.traces.entrySet()) {
                WebViewTraceModel webViewTraceModel = ((WebViewTraceModelWrapper)((Map.Entry)t).getValue()).getTraceModel();
                if (webViewTraceModel == null || webViewTraceModel.getUiTraceId() != l) continue;
                arrayList3.add(t);
            }
            Object object = arrayList;
            arrayList = new ArrayList<Long>(CollectionsKt.collectionSizeOrDefault(arrayList3, (int)10));
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                object.add(((Number)((Map.Entry)iterator.next()).getKey()).longValue());
            }
            object = object.iterator();
            while (object.hasNext()) {
                WebViewTraceRepositoryImpl webViewTraceRepositoryImpl = this;
                long l2 = ((Number)object.next()).longValue();
                webViewTraceRepositoryImpl.terminateTrace(webViewTraceRepositoryImpl.traces, l2);
            }
        }
    }

    @Override
    public boolean isWebViewSizeResolved(long l) {
        WebViewTraceModelWrapper webViewTraceModelWrapper = ((WebViewTraceRepositoryImpl)((Object)webViewTraceModelWrapper)).traces.get(l);
        return webViewTraceModelWrapper != null ? webViewTraceModelWrapper.isSizeResolved() : true;
    }

    @Override
    public boolean shouldCollectVitals(long l) {
        WebViewTraceModelWrapper webViewTraceModelWrapper = ((WebViewTraceRepositoryImpl)((Object)webViewTraceModelWrapper)).traces.get(l);
        return webViewTraceModelWrapper != null ? webViewTraceModelWrapper.shouldRegisterWebVitalsListener() : false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/instabug/apm/webview/webview_trace/handler/WebViewTraceRepositoryImpl$Companion;", "", "()V", "EVENT_COPY_COUNTS_CUT_OFF", "", "instabug-apm_defaultUiRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

