/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.util.device;

import android.app.Activity;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.PowerManager;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.instabug.apm.util.device.APMDeviceStateProvider;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.util.DeviceStateProvider;

public class APMDeviceStateProviderImpl
implements APMDeviceStateProvider {
    @Override
    public int getBatteryLevel(Context context) {
        return DeviceStateProvider.getBatteryLevel((Context)context);
    }

    @Override
    public int getRefreshRate(Context context) {
        APMDeviceStateProviderImpl aPMDeviceStateProviderImpl = Build.VERSION.SDK_INT >= 17 ? ((DisplayManager)context.getSystemService("display")).getDisplay(0) : ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        if (aPMDeviceStateProviderImpl != null) {
            return (int)aPMDeviceStateProviderImpl.getRefreshRate();
        }
        return 60;
    }

    @Override
    @Nullable
    public Boolean isPowerSaveModeEnabled(Context context) {
        APMDeviceStateProviderImpl aPMDeviceStateProviderImpl = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 21) {
            return aPMDeviceStateProviderImpl != null && aPMDeviceStateProviderImpl.isPowerSaveMode();
        }
        return null;
    }

    @Override
    public String getScreenOrientation(Activity activity) {
        return activity.getResources().getConfiguration().orientation == 2 ? "landscape" : "portrait";
    }

    @Override
    public boolean isProbablyAnEmulator() {
        return InstabugDeviceProperties.isProbablyAnEmulator();
    }
}

