/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.uitrace.handler;

import android.annotation.SuppressLint;
import androidx.annotation.RequiresApi;
import com.instabug.apm.cache.model.UiTraceCacheModel;
import com.instabug.apm.di.Provider;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.apm.uitrace.UiTraceWrapper;
import com.instabug.apm.uitrace.handler.UiTraceWrapperHandler;
import com.instabug.apm.uitrace.model.UiTraceEndParams;
import com.instabug.apm.uitrace.model.UiTraceInitParams;
import com.instabug.apm.uitrace.uihangs.UiHangHandler;
import com.instabug.apm.util.powermanagement.BatteryLevelChangeBroadcast;
import com.instabug.apm.util.powermanagement.PowerManagementCallback;
import com.instabug.apm.util.powermanagement.PowerSaveModeBroadcast;
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceEventListener;
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager;
import com.instabug.library.BuildFieldsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B?\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0002\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0015\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0011J\u0013\u0010\u0019\u001a\u00020\u000f*\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b \u0010\u0016J\u0017\u0010!\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u001f\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010#\u001a\u0004\b$\u0010%R\u001f\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010#\u001a\u0004\b&\u0010%R\u001f\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b'\u0010%R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010.\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/instabug/apm/uitrace/handler/UiTraceWrapperHandlerImpl;", "Lcom/instabug/apm/uitrace/handler/UiTraceWrapperHandler;", "Lcom/instabug/apm/di/Provider;", "Lcom/instabug/apm/util/powermanagement/BatteryLevelChangeBroadcast;", "batteryLevelChangeBroadcastProvider", "Lcom/instabug/apm/util/powermanagement/PowerSaveModeBroadcast;", "powerSaveModeBroadcastProvider", "Lcom/instabug/apm/webview/webview_trace/manager/WebViewTraceManager;", "webViewTraceManagerProvider", "Lcom/instabug/apm/handler/session/SessionHandler;", "sessionHandler", "<init>", "(Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/handler/session/SessionHandler;)V", "Lcom/instabug/apm/util/powermanagement/PowerManagementCallback;", "callback", "", "registerBroadcastReceivers", "(Lcom/instabug/apm/util/powermanagement/PowerManagementCallback;)V", "Lcom/instabug/apm/uitrace/UiTraceWrapper;", "Lcom/instabug/apm/uitrace/model/UiTraceEndParams;", "params", "updateCacheModel", "(Lcom/instabug/apm/uitrace/UiTraceWrapper;Lcom/instabug/apm/uitrace/model/UiTraceEndParams;)V", "unregisterBroadcastReceivers", "Lcom/instabug/apm/uitrace/uihangs/UiHangHandler;", "stopUiHangs", "(Lcom/instabug/apm/uitrace/uihangs/UiHangHandler;)V", "wrapper", "Lcom/instabug/apm/uitrace/model/UiTraceInitParams;", "initModel", "start", "(Lcom/instabug/apm/uitrace/UiTraceWrapper;Lcom/instabug/apm/uitrace/model/UiTraceInitParams;)V", "end", "clean", "(Lcom/instabug/apm/uitrace/UiTraceWrapper;)V", "Lcom/instabug/apm/di/Provider;", "getBatteryLevelChangeBroadcastProvider", "()Lcom/instabug/apm/di/Provider;", "getPowerSaveModeBroadcastProvider", "getWebViewTraceManagerProvider", "Lcom/instabug/apm/handler/session/SessionHandler;", "getSessionHandler", "()Lcom/instabug/apm/handler/session/SessionHandler;", "", "getCanCapturePowerSaving", "()Z", "canCapturePowerSaving", "instabug-apm_defaultUiRelease"}, xi=48)
@RequiresApi(value=16)
@SuppressLint(value={"NewApi"})
public final class UiTraceWrapperHandlerImpl
implements UiTraceWrapperHandler {
    @NotNull
    private final Provider<BatteryLevelChangeBroadcast> batteryLevelChangeBroadcastProvider;
    @NotNull
    private final Provider<PowerSaveModeBroadcast> powerSaveModeBroadcastProvider;
    @NotNull
    private final Provider<WebViewTraceManager> webViewTraceManagerProvider;
    @NotNull
    private final SessionHandler sessionHandler;

    public UiTraceWrapperHandlerImpl(@NotNull Provider<BatteryLevelChangeBroadcast> provider, @NotNull Provider<PowerSaveModeBroadcast> provider2, @NotNull Provider<WebViewTraceManager> provider3, @NotNull SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter(provider, (String)"batteryLevelChangeBroadcastProvider");
        Intrinsics.checkNotNullParameter(provider2, (String)"powerSaveModeBroadcastProvider");
        Intrinsics.checkNotNullParameter(provider3, (String)"webViewTraceManagerProvider");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        this.batteryLevelChangeBroadcastProvider = provider;
        this.powerSaveModeBroadcastProvider = provider2;
        this.webViewTraceManagerProvider = provider3;
        this.sessionHandler = sessionHandler;
    }

    private final boolean getCanCapturePowerSaving() {
        return BuildFieldsProvider.INSTANCE.provideBuildVersion() >= 21;
    }

    private final void registerBroadcastReceivers(PowerManagementCallback powerManagementCallback) {
        BatteryLevelChangeBroadcast batteryLevelChangeBroadcast = ((UiTraceWrapperHandlerImpl)this).batteryLevelChangeBroadcastProvider.invoke();
        if (batteryLevelChangeBroadcast != null) {
            batteryLevelChangeBroadcast.register(powerManagementCallback);
        }
        if (((UiTraceWrapperHandlerImpl)this).getCanCapturePowerSaving() && (this = ((UiTraceWrapperHandlerImpl)this).powerSaveModeBroadcastProvider.invoke()) != null) {
            ((PowerSaveModeBroadcast)((Object)this)).register(powerManagementCallback);
        }
    }

    private final void updateCacheModel(UiTraceWrapper uiTraceWrapper, UiTraceEndParams uiTraceEndParams) {
        UiTraceCacheModel uiTraceCacheModel = uiTraceWrapper.getCacheModel();
        uiTraceCacheModel.setRefreshRate(uiTraceEndParams.getRefreshRate());
        uiTraceCacheModel.setDuration(uiTraceEndParams.getElapsedTimeMicro() - uiTraceCacheModel.getStartTimeInMicros());
        String string = uiTraceCacheModel.getName();
        if (string == null) {
            string = "";
        }
        if (!Intrinsics.areEqual((Object)string, (Object)uiTraceEndParams.getActivityClassName())) {
            uiTraceCacheModel.setContainerName(uiTraceEndParams.getActivityClassName());
        }
        uiTraceCacheModel.setModuleName(uiTraceEndParams.getModuleName());
        uiTraceCacheModel.setUiHangsModel(uiTraceWrapper.getUiHangsHandler().getUiHangModel());
    }

    private final void unregisterBroadcastReceivers(PowerManagementCallback powerManagementCallback) {
        BatteryLevelChangeBroadcast batteryLevelChangeBroadcast = ((UiTraceWrapperHandlerImpl)this).batteryLevelChangeBroadcastProvider.invoke();
        if (batteryLevelChangeBroadcast != null) {
            batteryLevelChangeBroadcast.unregister(powerManagementCallback);
        }
        if (((UiTraceWrapperHandlerImpl)this).getCanCapturePowerSaving() && (this = ((UiTraceWrapperHandlerImpl)this).powerSaveModeBroadcastProvider.invoke()) != null) {
            ((PowerSaveModeBroadcast)((Object)this)).unregister(powerManagementCallback);
        }
    }

    private final void stopUiHangs(UiHangHandler uiHangHandler) {
        UiHangHandler uiHangHandler2 = uiHangHandler;
        uiHangHandler2.stop();
        uiHangHandler2.clearUiHangModel();
    }

    @Override
    public void start(@NotNull UiTraceWrapper object, @NotNull UiTraceInitParams uiTraceInitParams) {
        UiTraceWrapperHandlerImpl uiTraceWrapperHandlerImpl = uiTraceCacheModel;
        UiTraceWrapper uiTraceWrapper = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)uiTraceInitParams, (String)"initModel");
        ((UiTraceWrapperHandlerImpl)((Object)uiTraceCacheModel)).registerBroadcastReceivers(((UiTraceWrapper)object).getPowerManagementCallback());
        uiTraceWrapper.getUiHangsHandler().start();
        UiTraceCacheModel uiTraceCacheModel = uiTraceWrapper.getCacheModel();
        uiTraceCacheModel.setName(uiTraceInitParams.getName());
        uiTraceCacheModel.setScreenTitle(uiTraceInitParams.getScreenTitle());
        object = uiTraceWrapperHandlerImpl.sessionHandler.getCurrentSession();
        object = object != null ? object.getId() : null;
        uiTraceCacheModel.setSessionId((String)object);
        uiTraceCacheModel.setBatteryLevel(uiTraceInitParams.getBatteryLevel());
        uiTraceCacheModel.setPowerSaveMode(uiTraceInitParams.isPowerSaveModeEnabled());
        uiTraceCacheModel.setOrientation(uiTraceInitParams.getScreenOrientation());
        uiTraceCacheModel.setStartTimestamp(uiTraceInitParams.getTimeStampMicros());
        uiTraceCacheModel.setStartTimeInMicros(uiTraceInitParams.getStartTimeMicro());
        uiTraceCacheModel.setUserDefined(uiTraceInitParams.isUserDefined());
    }

    @Override
    public void end(@NotNull UiTraceWrapper uiTraceWrapper, @NotNull UiTraceEndParams object) {
        Intrinsics.checkNotNullParameter((Object)uiTraceWrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)object, (String)"params");
        this.updateCacheModel(uiTraceWrapper, (UiTraceEndParams)object);
        object = uiTraceWrapper.getWebViewTraceListener();
        if (object != null) {
            object.onUiTraceEnded();
        }
        this.clean(uiTraceWrapper);
    }

    @Override
    public void clean(@NotNull UiTraceWrapper object) {
        UiTraceWrapper uiTraceWrapper = object;
        Intrinsics.checkNotNullParameter((Object)uiTraceWrapper, (String)"wrapper");
        ((UiTraceWrapperHandlerImpl)this).unregisterBroadcastReceivers(uiTraceWrapper.getPowerManagementCallback());
        ((UiTraceWrapperHandlerImpl)this).stopUiHangs(((UiTraceWrapper)object).getUiHangsHandler());
        object = ((UiTraceWrapper)object).getWebViewTraceListener();
        if (object != null && (this = ((UiTraceWrapperHandlerImpl)this).webViewTraceManagerProvider.invoke()) != null) {
            this.unregisterWebViewEventListener((WebViewTraceEventListener)object);
        }
    }
}

