/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networkinterception.sanitization;

import android.net.Uri;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.apm.sanitization.Sanitizer;
import com.instabug.library.diagnostics.IBGDiagnostics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\b\u001a\u00020\f*\u00020\fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/instabug/apm/networkinterception/sanitization/InstabugRequestSanitizer;", "Lcom/instabug/apm/sanitization/Sanitizer;", "Lcom/instabug/apm/model/APMNetworkLog;", "instabugDomains", "", "", "sanitizationQueries", "(Ljava/util/Set;Ljava/util/Set;)V", "sanitize", "item", "hasInstabugDomain", "", "Landroid/net/Uri;", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nInstabugRequestSanitizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstabugRequestSanitizer.kt\ncom/instabug/apm/networkinterception/sanitization/InstabugRequestSanitizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,36:1\n1#2:37\n1549#3:38\n1620#3,3:39\n1747#3,3:44\n1295#4,2:42\n*S KotlinDebug\n*F\n+ 1 InstabugRequestSanitizer.kt\ncom/instabug/apm/networkinterception/sanitization/InstabugRequestSanitizer\n*L\n27#1:38\n27#1:39,3\n35#1:44,3\n30#1:42,2\n*E\n"})
public final class InstabugRequestSanitizer
implements Sanitizer<APMNetworkLog> {
    @NotNull
    private final Set<String> instabugDomains;
    @NotNull
    private final Set<String> sanitizationQueries;

    public InstabugRequestSanitizer(@NotNull Set<String> set, @NotNull Set<String> set2) {
        Intrinsics.checkNotNullParameter(set, (String)"instabugDomains");
        Intrinsics.checkNotNullParameter(set2, (String)"sanitizationQueries");
        this.instabugDomains = set;
        this.sanitizationQueries = set2;
    }

    @Override
    private final Uri sanitize(Uri uri) {
        ArrayList<String> arrayList;
        InstabugRequestSanitizer instabugRequestSanitizer = instabugRequestSanitizer2;
        InstabugRequestSanitizer instabugRequestSanitizer2 = uri.buildUpon().clearQuery();
        Object object = instabugRequestSanitizer.sanitizationQueries;
        Object object22 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            String string = ((String)object.next()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            object22.add(string);
        }
        Set set = uri.getQueryParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"queryParameterNames");
        for (Object object22 : SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)new Function1<String, Boolean>(object22){
            final /* synthetic */ List<String> $keywords;
            {
                this.$keywords = list;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String string) {
                String string2 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                return this.$keywords.contains(string3);
            }
        })) {
            instabugRequestSanitizer2.appendQueryParameter((String)object22, uri.getQueryParameter((String)object22));
        }
        Uri uri2 = instabugRequestSanitizer2.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"newUri.build()");
        return uri2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInstabugDomain(Uri uri) {
        String string;
        Object object = ((InstabugRequestSanitizer)object).instabugDomains;
        if (object instanceof Collection && object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        do {
            if (!object.hasNext()) return false;
            string = (String)object.next();
        } while (!StringsKt.equals((String)uri.getHost(), (String)string, (boolean)true));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public APMNetworkLog sanitize(@NotNull APMNetworkLog aPMNetworkLog) {
        Exception exception2;
        block4: {
            String string;
            block5: {
                block3: {
                    APMNetworkLog aPMNetworkLog2 = aPMNetworkLog;
                    Intrinsics.checkNotNullParameter((Object)aPMNetworkLog2, (String)"item");
                    try {
                        string = aPMNetworkLog2.getUrl();
                        if (string == null) break block3;
                    }
                    catch (Exception exception2) {
                        break block4;
                    }
                    string = Uri.parse((String)string);
                    break block5;
                }
                string = null;
            }
            if (string == null) return aPMNetworkLog;
            if (!this.hasInstabugDomain((Uri)string)) return aPMNetworkLog;
            aPMNetworkLog.setUrl(this.sanitize((Uri)string).toString());
            return aPMNetworkLog;
        }
        IBGDiagnostics.reportNonFatal((Throwable)exception2, (String)("failed to parse string to uri: " + aPMNetworkLog.getUrl()));
        return aPMNetworkLog;
    }
}

