/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networkinterception;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.apm.di.InterceptorsServiceLocator;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.networkinterception.APMNetworkLogWrapper;
import com.instabug.apm.networkinterception.utils.APMCountableInputStream;
import com.instabug.apm.networkinterception.utils.APMCountableOutputStream;
import com.instabug.apm.networkinterception.utils.UrlConnectionHeaderUtilsKt;
import com.instabug.library.networkv2.BodyBufferHelper;
import com.instabug.library.util.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;

public class APMHttpsUrlConnection
extends HttpsURLConnection
implements APMCountableInputStream.Callback {
    private final Logger logger = ServiceLocator.getApmLogger();
    private final HttpsURLConnection connection;
    private final long startTimeNano;
    private final HashMap<String, String> requestHeaders = new HashMap();
    private final APMNetworkLogWrapper networkLogWrapper;
    private long startTime;
    @Nullable
    private APMCountableOutputStream countableOutputStream;
    @Nullable
    private APMCountableInputStream apmCountableInputStream;

    APMHttpsUrlConnection(HttpsURLConnection httpsURLConnection) {
        super(httpsURLConnection.getURL());
        APMNetworkLogWrapper aPMNetworkLogWrapper;
        APMNetworkLogWrapper aPMNetworkLogWrapper2 = aPMNetworkLogWrapper;
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        APMNetworkLogWrapper aPMNetworkLogWrapper3 = aPMNetworkLogWrapper2;
        aPMNetworkLogWrapper3();
        this.networkLogWrapper = aPMNetworkLogWrapper3;
        aPMHttpsUrlConnection.connection = httpsURLConnection;
        aPMHttpsUrlConnection.startTime = System.currentTimeMillis() * 1000L;
        aPMHttpsUrlConnection.startTimeNano = System.nanoTime();
        aPMNetworkLogWrapper.setUrl(httpsURLConnection.getURL().toString());
        UrlConnectionHeaderUtilsKt.injectExternalNetworkTraceIdHeaderIfPossible(httpsURLConnection, aPMNetworkLogWrapper);
    }

    private void logNetworkCall(@Nullable Exception exception) {
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        aPMHttpsUrlConnection.logNetworkCall(aPMHttpsUrlConnection.startTime, null, exception);
    }

    private void logNetworkCall(long l, @Nullable Long l2, @Nullable Exception exception) {
        APMCountableOutputStream aPMCountableOutputStream = this.countableOutputStream;
        if (aPMCountableOutputStream == null) {
            this.networkLogWrapper.setRequestBodySize(0L);
        } else {
            this.networkLogWrapper.setRequestBodySize(aPMCountableOutputStream.getCount());
        }
        if (l2 != null) {
            this.networkLogWrapper.setResponseBodySize(l2);
        }
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        aPMHttpsUrlConnection.networkLogWrapper.setStartTime(l);
        l = aPMHttpsUrlConnection.getDurationMillis(aPMHttpsUrlConnection.startTimeNano);
        aPMHttpsUrlConnection.networkLogWrapper.setTotalDuration(l);
        aPMHttpsUrlConnection.networkLogWrapper.setRequestHeaders(ObjectMapper.toJson(this.requestHeaders).toString());
        aPMHttpsUrlConnection.networkLogWrapper.setRequestBody(this.getRequestBody());
        aPMHttpsUrlConnection.networkLogWrapper.setResponseBody(this.getResponseBody());
        if (aPMHttpsUrlConnection.networkLogWrapper.getResponseCode() > 0) {
            this.networkLogWrapper.setErrorMessage(null);
        }
        this.networkLogWrapper.insert(exception, InterceptorsServiceLocator.getHttpUrlConnectionSanitizer());
    }

    @Nullable
    private String getResponseBody() {
        APMCountableInputStream aPMCountableInputStream = ((APMHttpsUrlConnection)((Object)aPMCountableInputStream)).apmCountableInputStream;
        if (aPMCountableInputStream != null) {
            return aPMCountableInputStream.getBody();
        }
        return null;
    }

    @Nullable
    private String getRequestBody() {
        return null;
    }

    private long getDurationMillis(long l) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
    }

    @Nullable
    private InputStream countingInputStream(InputStream inputStream) {
        APMCountableInputStream aPMCountableInputStream;
        if (inputStream == null) {
            return null;
        }
        APMCountableInputStream aPMCountableInputStream2 = aPMCountableInputStream;
        aPMCountableInputStream2(inputStream, this);
        this.apmCountableInputStream = aPMCountableInputStream2;
        return aPMCountableInputStream;
    }

    @Override
    public void connect() {
        Exception exception2;
        block4: {
            Throwable throwable2;
            APMHttpsUrlConnection aPMHttpsUrlConnection = this;
            aPMHttpsUrlConnection.startTime = System.currentTimeMillis() * 1000L;
            String string = this.connection.getRequestMethod();
            aPMHttpsUrlConnection.logger.d("Request [$method] $url has started.".replace("$method", string).replace("$url", this.connection.getURL().toString()));
            aPMHttpsUrlConnection.logNetworkCall(null);
            try {
                try {
                    aPMHttpsUrlConnection.connection.connect();
                    return;
                }
                catch (Throwable throwable2) {
                }
            }
            catch (Exception exception2) {
                break block4;
            }
            throw throwable2;
        }
        this.networkLogWrapper.setErrorMessage(exception2.getClass().getSimpleName());
        this.logNetworkCall(exception2);
        throw exception2;
    }

    @Override
    public void addRequestProperty(@Nullable String string, @Nullable String string2) {
        if (string != null) {
            this.requestHeaders.put(string, string2);
            if (string.equalsIgnoreCase("content-type")) {
                APMCountableOutputStream aPMCountableOutputStream = this.countableOutputStream;
                if (aPMCountableOutputStream != null) {
                    aPMCountableOutputStream.setDisableBodyBuffer(BodyBufferHelper.isMultipartType((String)string2));
                }
                this.networkLogWrapper.setRequestContentType(string2);
            }
            if (string2 != null) {
                this.connection.addRequestProperty(string, string2);
            }
        }
    }

    @Override
    public String getCipherSuite() {
        return this.connection.getCipherSuite();
    }

    @Override
    public boolean usingProxy() {
        return this.connection.usingProxy();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.connection.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() {
        try {
            return this.connection.getServerCertificates();
        }
        catch (Exception exception) {
            this.networkLogWrapper.setErrorMessage(exception.getClass().getSimpleName());
            this.logNetworkCall(exception);
            throw exception;
        }
    }

    @Override
    public Principal getPeerPrincipal() {
        try {
            return this.connection.getPeerPrincipal();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            this.networkLogWrapper.setErrorMessage(sSLPeerUnverifiedException.getClass().getSimpleName());
            this.logNetworkCall(sSLPeerUnverifiedException);
            throw sSLPeerUnverifiedException;
        }
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return ((URLConnection)this.connection).getHeaderFieldKey(n);
    }

    @Override
    public void setFixedLengthStreamingMode(int n) {
        this.connection.setFixedLengthStreamingMode(n);
    }

    @Override
    @RequiresApi(api=19)
    public void setFixedLengthStreamingMode(long l) {
        this.connection.setFixedLengthStreamingMode(l);
    }

    @Override
    public void setChunkedStreamingMode(int n) {
        this.connection.setChunkedStreamingMode(n);
    }

    @Override
    public String getHeaderField(int n) {
        return ((URLConnection)this.connection).getHeaderField(n);
    }

    @Override
    public void onReadCompleted(long l) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : this.connection.getHeaderFields().entrySet()) {
            if (entry.getKey() == null) continue;
            hashMap2.put(entry.getKey().toString(), entry.getValue().toString());
            if (!entry.getKey().toString().equalsIgnoreCase("content-type")) continue;
            entry = entry.getValue().toString();
            this.networkLogWrapper.setResponseContentType((String)((Object)entry));
        }
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        aPMHttpsUrlConnection.networkLogWrapper.setResponseHeaders(ObjectMapper.toJson(hashMap2).toString());
        long l2 = aPMHttpsUrlConnection.startTime;
        Long l3 = l;
        this.logNetworkCall(l2, l3, null);
    }

    @Override
    public void disconnect() {
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        aPMHttpsUrlConnection.logNetworkCall(null);
        aPMHttpsUrlConnection.connection.disconnect();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.connection.getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean bl) {
        this.connection.setAllowUserInteraction(bl);
    }

    @Override
    public int getConnectTimeout() {
        return this.connection.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int n) {
        this.connection.setConnectTimeout(n);
    }

    @Override
    public Object getContent() {
        try {
            return this.connection.getContent();
        }
        catch (IOException iOException) {
            this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
            this.logNetworkCall(iOException);
            throw iOException;
        }
    }

    public Object getContent(Class[] classArray) {
        try {
            return this.connection.getContent(classArray);
        }
        catch (IOException iOException) {
            this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
            this.logNetworkCall(iOException);
            throw iOException;
        }
    }

    @Override
    public int getContentLength() {
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        int n = aPMHttpsUrlConnection.connection.getContentLength();
        if (aPMHttpsUrlConnection.networkLogWrapper.getResponseBodySize() == 0L) {
            APMHttpsUrlConnection aPMHttpsUrlConnection2 = this;
            aPMHttpsUrlConnection2.networkLogWrapper.setResponseBodySize(n);
            aPMHttpsUrlConnection2.logNetworkCall(null);
        }
        return n;
    }

    @Override
    @RequiresApi(api=24)
    public long getContentLengthLong() {
        return this.connection.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    @Override
    public long getDate() {
        return this.connection.getDate();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.connection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean bl) {
        this.connection.setDefaultUseCaches(bl);
    }

    @Override
    public String getContentEncoding() {
        return this.connection.getContentEncoding();
    }

    @Override
    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION"})
    public InputStream getInputStream() {
        InputStream inputStream;
        block3: {
            try {
                APMHttpsUrlConnection aPMHttpsUrlConnection = this;
                inputStream = aPMHttpsUrlConnection.countingInputStream(aPMHttpsUrlConnection.connection.getInputStream());
                if (inputStream != null) break block3;
            }
            catch (IOException iOException) {
                this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
                this.logNetworkCall(iOException);
                throw iOException;
            }
            inputStream = this.connection.getInputStream();
        }
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OutputStream getOutputStream() {
        try {
            if (this.countableOutputStream != null) return this.countableOutputStream;
            this.countableOutputStream = new APMCountableOutputStream(this.connection.getOutputStream());
            return this.countableOutputStream;
        }
        catch (IOException iOException) {}
        this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
        this.logNetworkCall(iOException);
        throw iOException;
    }

    @Override
    public void setRequestMethod(String string) {
        try {
            APMHttpsUrlConnection aPMHttpsUrlConnection = this;
            aPMHttpsUrlConnection.connection.setRequestMethod(string);
            aPMHttpsUrlConnection.networkLogWrapper.setMethod(string);
            return;
        }
        catch (ProtocolException protocolException) {
            this.networkLogWrapper.setErrorMessage(protocolException.getClass().getSimpleName());
            this.logNetworkCall(protocolException);
            throw protocolException;
        }
    }

    @Override
    public void setRequestProperty(@Nullable String string, @Nullable String string2) {
        if (string != null) {
            this.requestHeaders.put(string, string2);
            if (string.equalsIgnoreCase("content-type")) {
                this.networkLogWrapper.setRequestContentType(string2);
            }
            if (string2 != null) {
                this.connection.setRequestProperty(string, string2);
            }
        }
    }

    @Override
    public void setDoOutput(boolean bl) {
        this.connection.setDoOutput(bl);
    }

    @Override
    public void setDoInput(boolean bl) {
        this.connection.setDoInput(bl);
    }

    @Override
    public boolean getDoInput() {
        return this.connection.getDoInput();
    }

    @Override
    public boolean getDoOutput() {
        return this.connection.getDoOutput();
    }

    @Override
    @SuppressLint(value={"ERADICATE_INCONSISTENT_SUBCLASS_RETURN_ANNOTATION"})
    @Nullable
    public InputStream getErrorStream() {
        InputStream inputStream;
        if (this.connection.getContentLength() > 0) {
            APMHttpsUrlConnection aPMHttpsUrlConnection = this;
            inputStream = aPMHttpsUrlConnection.countingInputStream(aPMHttpsUrlConnection.connection.getErrorStream());
            if (inputStream == null) {
                inputStream = this.connection.getErrorStream();
            }
        } else {
            inputStream = this.connection.getErrorStream();
        }
        this.logNetworkCall(null);
        return inputStream;
    }

    @Override
    public long getExpiration() {
        return this.connection.getExpiration();
    }

    @Override
    public String getHeaderField(String string) {
        if (string != null) {
            return this.connection.getHeaderField(string);
        }
        return "";
    }

    @Override
    public int getHeaderFieldInt(String string, int n) {
        return this.connection.getHeaderFieldInt(string, n);
    }

    @Override
    public long getHeaderFieldDate(String string, long l) {
        return ((URLConnection)this.connection).getHeaderFieldDate(string, l);
    }

    @Override
    @RequiresApi(api=24)
    public long getHeaderFieldLong(String string, long l) {
        return this.connection.getHeaderFieldLong(string, l);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.connection.getHeaderFields();
    }

    @Override
    public long getIfModifiedSince() {
        return this.connection.getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long l) {
        this.connection.setIfModifiedSince(l);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.connection.getInstanceFollowRedirects();
    }

    @Override
    public void setInstanceFollowRedirects(boolean bl) {
        this.connection.setInstanceFollowRedirects(bl);
    }

    @Override
    public long getLastModified() {
        return this.connection.getLastModified();
    }

    @Override
    public Permission getPermission() {
        try {
            return ((URLConnection)this.connection).getPermission();
        }
        catch (IOException iOException) {
            this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
            this.logNetworkCall(iOException);
            throw iOException;
        }
    }

    @Override
    public int getReadTimeout() {
        return this.connection.getReadTimeout();
    }

    @Override
    public void setReadTimeout(int n) {
        this.connection.setReadTimeout(n);
    }

    @Override
    public String getRequestMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.connection.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String string) {
        return this.connection.getRequestProperty(string);
    }

    @Override
    public int getResponseCode() {
        int n;
        try {
            n = this.connection.getResponseCode();
        }
        catch (IOException iOException) {
            this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
            throw iOException;
        }
        APMHttpsUrlConnection aPMHttpsUrlConnection = this;
        aPMHttpsUrlConnection.networkLogWrapper.setResponseCode(n);
        aPMHttpsUrlConnection.logNetworkCall(null);
        return n;
    }

    @Override
    public String getResponseMessage() {
        try {
            return this.connection.getResponseMessage();
        }
        catch (IOException iOException) {
            this.networkLogWrapper.setErrorMessage(iOException.getClass().getSimpleName());
            this.logNetworkCall(iOException);
            throw iOException;
        }
    }

    @Override
    public URL getURL() {
        return this.connection.getURL();
    }

    @Override
    public boolean getUseCaches() {
        return this.connection.getUseCaches();
    }

    @Override
    public void setUseCaches(boolean bl) {
        this.connection.setUseCaches(bl);
    }

    @Override
    @NonNull
    public String toString() {
        return ((Object)this.connection).toString();
    }
}

