/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.networking.handler;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.networking.APMSyncException;
import com.instabug.apm.networking.Endpoints;
import com.instabug.apm.networking.handler.SyncManagerNetworkHandler;
import com.instabug.apm.networking.mapping.sessions.SessionMapper;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.settings.SettingsManager;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;

public class SyncManagerNetworkHandlerImpl
implements SyncManagerNetworkHandler {
    private final SessionMapper sessionMapper = ServiceLocator.getSessionMapper();
    @VisibleForTesting
    @Nullable
    Request request;

    private void doRequest(@Nullable Request request, Request.Callbacks<RequestResponse, Throwable> callbacks) {
        if (request != null) {
            ServiceLocator.getNetworkManager().doRequest("CORE", 1, request, callbacks);
        } else {
            APMSyncException aPMSyncException;
            APMSyncException aPMSyncException2 = aPMSyncException;
            aPMSyncException = new APMSyncException("Request object can't be null");
            callbacks.onFailed((Object)aPMSyncException2);
        }
    }

    @Override
    public void syncSessions(@NonNull List<SessionCacheModel> list, Request.Callbacks<RequestResponse, Throwable> callbacks) {
        SyncManagerNetworkHandlerImpl syncManagerNetworkHandlerImpl = syncManagerNetworkHandlerImpl4;
        SyncManagerNetworkHandlerImpl syncManagerNetworkHandlerImpl2 = syncManagerNetworkHandlerImpl;
        SyncManagerNetworkHandlerImpl syncManagerNetworkHandlerImpl3 = syncManagerNetworkHandlerImpl;
        SyncManagerNetworkHandlerImpl syncManagerNetworkHandlerImpl4 = syncManagerNetworkHandlerImpl.constructRequest(syncManagerNetworkHandlerImpl.sessionMapper.toJsonArray(list));
        try {
            syncManagerNetworkHandlerImpl2.request = syncManagerNetworkHandlerImpl4;
            syncManagerNetworkHandlerImpl3.doRequest((Request)syncManagerNetworkHandlerImpl4, callbacks);
        }
        catch (Exception exception) {
            callbacks.onFailed((Object)exception);
        }
    }

    @VisibleForTesting
    public Request constructRequest(JSONArray jSONArray) {
        int n;
        Object object = ServiceLocator.getDebugUtils();
        Object[] objectArray = ServiceLocator.getDeviceStateProvider();
        jSONArray = new Request.Builder().url(Endpoints.SYNC_SESSIONS).method("POST").addParameter(new RequestParameter("ses", (Object)jSONArray)).shorten(true).tokenProvider(() -> SettingsManager.getInstance().getAppToken()).hasUuid(false);
        String string = ServiceLocator.getAppToken();
        if (string != null) {
            jSONArray.addHeader(new RequestParameter("IBG-APP-TOKEN", (Object)string)).addParameter(new RequestParameter("at", (Object)string));
        }
        if (objectArray.isProbablyAnEmulator()) {
            jSONArray.addParameter(new RequestParameter("dv", (Object)("Emulator - " + InstabugDeviceProperties.getDeviceType())));
        } else {
            RequestParameter requestParameter;
            objectArray = requestParameter;
            requestParameter = new RequestParameter("dv", (Object)InstabugDeviceProperties.getDeviceType());
            jSONArray.addParameter((RequestParameter)objectArray);
        }
        if (object.isInDebugMode()) {
            RequestParameter requestParameter;
            RequestParameter requestParameter2;
            JSONArray jSONArray2 = jSONArray;
            object = requestParameter2;
            requestParameter2 = new RequestParameter("IBG-APM-DEBUG-MODE", (Object)"true");
            jSONArray2.addHeader((RequestParameter)object);
            object = requestParameter;
            requestParameter = new RequestParameter("dm", (Object)Boolean.TRUE);
            jSONArray2.addParameter((RequestParameter)object);
        }
        if ((object = ServiceLocator.getApmStateProvider()) != null && (n = object.getStoreLimitDroppedSessionsCount()) > 0) {
            RequestParameter requestParameter;
            objectArray = requestParameter;
            requestParameter = new RequestParameter("dssl", (Object)n);
            jSONArray.addParameter((RequestParameter)objectArray);
            objectArray = ServiceLocator.getApmLogger();
            if (objectArray != null) {
                Object[] objectArray2 = objectArray;
                Integer n2 = n;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = n2;
                objectArray2.logSDKWarning(String.format(Locale.ENGLISH, "%d sessions have been dropped due to reaching sessions storage limit. Please contact support for more information.", objectArray));
            }
        }
        return jSONArray.build();
    }
}

