/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.uitrace.uiloading;

import androidx.annotation.Nullable;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.handler.uitrace.uiloading.ActivityEventToUiLoadingModelMapper;
import com.instabug.apm.model.EmptyTimeMetric;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.util.ArrayKtxKt;
import java.util.concurrent.TimeUnit;

public class DefaultActivityEventToUiLoadingModelMapper
implements ActivityEventToUiLoadingModelMapper {
    private boolean hasCustomEndScreenLoading(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[10] instanceof EmptyTimeMetric ^ true;
    }

    private boolean isCustomEndScreenLoadingValid(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[10].getNanoTime() > eventTimeMetricCaptureArray[9].getNanoTime();
    }

    private long getStartTimeStampMicro(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[1].getTimeStampMicro();
    }

    private long getCreatedDurationNano(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[4].getNanoTime() - eventTimeMetricCaptureArray[1].getNanoTime();
    }

    private long getCreatedTimestampMicro(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[1].getTimeStampMicro();
    }

    private long getStartedDurationNano(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[7].getNanoTime() - eventTimeMetricCaptureArray[4].getNanoTime();
    }

    private long getStartedTimestampMicro(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[4].getTimeStampMicro();
    }

    private long getResumedDurationNano(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[9].getNanoTime() - eventTimeMetricCaptureArray[7].getNanoTime();
    }

    private long getResumedTimestampMicro(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[7].getTimeStampMicro();
    }

    private long getCustomEndScreenLoadingDurationNano(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        if (this.isCustomEndScreenLoadingValid(eventTimeMetricCaptureArray)) {
            return eventTimeMetricCaptureArray[10].getNanoTime() - eventTimeMetricCaptureArray[9].getNanoTime();
        }
        return 0L;
    }

    private long getCustomEndScreenLoadingTimestampMicro(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        return eventTimeMetricCaptureArray[9].getTimeStampMicro();
    }

    private long getTotalTimeNano(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        if (this.hasCustomEndScreenLoading(eventTimeMetricCaptureArray) && this.isCustomEndScreenLoadingValid(eventTimeMetricCaptureArray)) {
            return eventTimeMetricCaptureArray[10].getNanoTime() - eventTimeMetricCaptureArray[1].getNanoTime();
        }
        return eventTimeMetricCaptureArray[9].getNanoTime() - eventTimeMetricCaptureArray[1].getNanoTime();
    }

    @Override
    @Nullable
    public UiLoadingModel getUiLoadingModel(EventTimeMetricCapture[] eventTimeMetricCaptureArray) {
        ArrayKtxKt.replaceNulls(eventTimeMetricCaptureArray, new EmptyTimeMetric());
        if (eventTimeMetricCaptureArray.length == 11) {
            UiLoadingModel uiLoadingModel;
            UiLoadingModel uiLoadingModel2;
            UiLoadingModel uiLoadingModel3 = uiLoadingModel2 = uiLoadingModel;
            uiLoadingModel2();
            uiLoadingModel3.setStartTimeStampMicro(this.getStartTimeStampMicro(eventTimeMetricCaptureArray));
            TimeUnit timeUnit = TimeUnit.NANOSECONDS;
            uiLoadingModel2.setDurationInMicro(timeUnit.toMicros(this.getTotalTimeNano(eventTimeMetricCaptureArray)));
            uiLoadingModel2.addStage("ac_on_c_mus", timeUnit.toMicros(this.getCreatedDurationNano(eventTimeMetricCaptureArray)));
            uiLoadingModel2.addStage("ac_on_c_mus_st", this.getCreatedTimestampMicro(eventTimeMetricCaptureArray));
            uiLoadingModel2.addStage("ac_on_st_mus", timeUnit.toMicros(this.getStartedDurationNano(eventTimeMetricCaptureArray)));
            uiLoadingModel2.addStage("ac_on_st_mus_st", this.getStartedTimestampMicro(eventTimeMetricCaptureArray));
            uiLoadingModel3.addStage("ac_on_r_mus", timeUnit.toMicros(this.getResumedDurationNano(eventTimeMetricCaptureArray)));
            uiLoadingModel.addStage("ac_on_r_mus_st", this.getResumedTimestampMicro(eventTimeMetricCaptureArray));
            if (this.hasCustomEndScreenLoading(eventTimeMetricCaptureArray)) {
                long l = timeUnit.toMicros(this.getCustomEndScreenLoadingDurationNano(eventTimeMetricCaptureArray));
                uiLoadingModel2.addStage("esl_mus", l);
                if (l != 0L) {
                    uiLoadingModel2.addStage("esl_mus_st", this.getCustomEndScreenLoadingTimestampMicro(eventTimeMetricCaptureArray));
                }
            }
            return uiLoadingModel2;
        }
        return null;
    }
}

