/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.handler.executiontraces;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.apm.cache.handler.executiontraces.DanglingExecutionTracesCacheHandler;
import com.instabug.apm.cache.handler.executiontraces.ExecutionTracesCacheHandler;
import com.instabug.apm.cache.handler.session.SessionMetaDataCacheHandler;
import com.instabug.apm.cache.model.ExecutionTraceCacheModel;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.handler.executiontraces.ExecutionTracesHandler;
import com.instabug.apm.handler.session.SessionHandler;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.model.common.Session;
import java.util.List;

@WorkerThread
public class ExecutionTracesHandlerImpl
implements ExecutionTracesHandler {
    private ExecutionTracesCacheHandler executionTracesCacheHandler = ServiceLocator.getExecutionTracesCacheHandler();
    private DanglingExecutionTracesCacheHandler danglingExecutionTracesCacheHandler = ServiceLocator.getDanglingExecutionTracesCacheHandler();
    private Logger apmLogger = ServiceLocator.getApmLogger();
    private SessionHandler sessionHandler = ServiceLocator.getSessionHandler();
    @Nullable
    private SessionMetaDataCacheHandler sessionMetaDataCacheHandler = ServiceLocator.getSessionMetaDataCacheHandler();
    private APMConfigurationProvider apmConfigurationProvider = ServiceLocator.getApmConfigurationProvider();

    private int trimTracesToLimit(String string, long l) {
        return this.executionTracesCacheHandler.trimTracesToLimit(string, l);
    }

    @Override
    public void removeAll() {
        ExecutionTracesHandlerImpl executionTracesHandlerImpl = sessionMetaDataCacheHandler;
        executionTracesHandlerImpl.executionTracesCacheHandler.removeAll();
        executionTracesHandlerImpl.danglingExecutionTracesCacheHandler.removeAll();
        SessionMetaDataCacheHandler sessionMetaDataCacheHandler = executionTracesHandlerImpl.sessionMetaDataCacheHandler;
        if (sessionMetaDataCacheHandler != null) {
            sessionMetaDataCacheHandler.resetTracesCounts();
        }
    }

    @Override
    public void removeUnEndedTraces() {
        ExecutionTracesHandlerImpl executionTracesHandlerImpl = this;
        executionTracesHandlerImpl.executionTracesCacheHandler.removeUnEndedTraces();
        executionTracesHandlerImpl.danglingExecutionTracesCacheHandler.removeUnEndedTraces();
    }

    @Override
    @Nullable
    public List<ExecutionTraceCacheModel> getExecutionTracesForSession(String string) {
        return this.executionTracesCacheHandler.getExecutionTracesForSession(string);
    }

    public void trimTracesToLimit(long l) {
        this.executionTracesCacheHandler.trimTracesToLimit(l);
    }

    @Override
    public boolean insertTrace(ExecutionTraceCacheModel object) {
        Session session = this.sessionHandler.getCurrentSession();
        if (session != null) {
            boolean bl = this.executionTracesCacheHandler.insertTrace(session.getId(), (ExecutionTraceCacheModel)object);
            if (bl) {
                object = this.sessionMetaDataCacheHandler;
                if (object != null) {
                    object.addToTracesTotalCount(session.getId(), 1);
                    int n = this.trimTracesToLimit(session.getId(), this.apmConfigurationProvider.getExecutionTraceLimitPerRequest());
                    if (n > 0) {
                        this.sessionMetaDataCacheHandler.addToTracesDroppedCount(session.getId(), n);
                    }
                }
                ExecutionTracesHandlerImpl executionTracesHandlerImpl = this;
                executionTracesHandlerImpl.trimTracesToLimit(executionTracesHandlerImpl.apmConfigurationProvider.getExecutionTraceStoreLimit());
            } else {
                this.apmLogger.logSDKProtected("Session meta data was not updated. Failed to insert custom trace " + ((ExecutionTraceCacheModel)object).getName());
            }
            return bl;
        }
        return this.danglingExecutionTracesCacheHandler.insertTrace((ExecutionTraceCacheModel)object);
    }
}

