/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.model;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.apm.cache.model.UiHangModel;
import com.instabug.apm.cache.model.UiLoadingModel;
import com.instabug.apm.util.flag_ext.ByteFlagExtKt;
import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel;
import java.util.List;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class UiTraceCacheModel {
    private long id = -1L;
    private boolean userDefined;
    @Nullable
    private String name;
    private long duration;
    private long largeDropsDuration;
    private long smallDropsDuration;
    private long startTime;
    private int refreshRate;
    @Nullable
    private String screenTitle = null;
    private int batteryLevel = -1;
    @Nullable
    private Boolean powerSaveMode = null;
    @Nullable
    private String containerName = null;
    @Nullable
    private String moduleName = null;
    @Nullable
    private String orientation = null;
    @Nullable
    private String sessionId;
    @Nullable
    private UiLoadingModel uiLoadingModel = null;
    @Nullable
    private List<WebViewCacheModel> webViewTraces = null;
    private long startTimeInMicros;
    private byte currentCacheState;

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Nullable
    public String getScreenTitle() {
        return this.screenTitle;
    }

    public void setScreenTitle(String string) {
        this.screenTitle = string;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public void setBatteryLevel(int n) {
        this.batteryLevel = n;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int n) {
        this.refreshRate = n;
    }

    @Nullable
    public Boolean getPowerSaveMode() {
        return this.powerSaveMode;
    }

    public void setPowerSaveMode(@Nullable Boolean bl) {
        this.powerSaveMode = bl;
    }

    public long getStartTimestamp() {
        return this.startTime;
    }

    public void setStartTimestamp(long l) {
        this.startTime = l;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public long getLargeDropsDuration() {
        return this.largeDropsDuration;
    }

    public void setLargeDropsDuration(long l) {
        this.largeDropsDuration = l;
    }

    public long getSmallDropsDuration() {
        return this.smallDropsDuration;
    }

    public void setSmallDropsDuration(long l) {
        this.smallDropsDuration = l;
    }

    public void setUiHangsModel(@Nullable UiHangModel uiHangModel) {
        if (uiHangModel != null) {
            this.largeDropsDuration = uiHangModel.getLargeDropsDuration();
            this.smallDropsDuration = uiHangModel.getSmallDropsDuration();
        } else {
            UiTraceCacheModel uiTraceCacheModel = this;
            uiTraceCacheModel.largeDropsDuration = -1L;
            uiTraceCacheModel.smallDropsDuration = -1L;
        }
    }

    @Nullable
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String string) {
        this.containerName = string;
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    @Nullable
    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String string) {
        this.orientation = string;
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean bl) {
        this.userDefined = bl;
    }

    public long getStartTimeInMicros() {
        return this.startTimeInMicros;
    }

    public void setStartTimeInMicros(long l) {
        this.startTimeInMicros = l;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(@Nullable String string) {
        this.sessionId = string;
    }

    @Nullable
    public UiLoadingModel getUiLoadingModel() {
        return this.uiLoadingModel;
    }

    public void setUiLoadingModel(@Nullable UiLoadingModel uiLoadingModel) {
        this.uiLoadingModel = uiLoadingModel;
    }

    @Nullable
    public List<WebViewCacheModel> getWebViewTraces() {
        return this.webViewTraces;
    }

    public void setWebViewTraces(@Nullable List<WebViewCacheModel> list) {
        this.webViewTraces = list;
    }

    public int getWebViewTraceCount() {
        List<WebViewCacheModel> list = ((UiTraceCacheModel)((Object)list)).webViewTraces;
        return list != null ? list.size() : 0;
    }

    public void updateCacheState(byte by) {
        this.currentCacheState = ByteFlagExtKt.addFlag(this.currentCacheState, by);
    }

    public boolean cacheStateIncludes(byte by) {
        return ByteFlagExtKt.hasFlag(this.currentCacheState, by);
    }

    @NonNull
    public String toString() {
        return "\nScrName:\t" + this.name + "\nScrTitle:\t" + this.screenTitle + "\nScrStTime:\t" + this.startTime + "\nScrVisit:\t" + this.duration + "\nSmallDrops:\t" + this.smallDropsDuration + "\nLargeDrop:\t" + this.largeDropsDuration + "\nRefresh:\t" + this.refreshRate + "\nPowerSave:\t" + this.powerSaveMode + "\nContainer:\t" + this.containerName + "\nModule:\t\t" + this.moduleName + "\nOrientat:\t" + this.orientation + "\nUserDefine:\t" + this.orientation + "\nBattery:\t" + this.batteryLevel + "\nSession:\t" + this.sessionId;
    }
}

