/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.cache.handler.networklog;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.apm.cache.handler.networklog.DanglingNetworkLogCacheHandler;
import com.instabug.apm.di.Provider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.apm.model.DefaultAPMNetworkLog;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.List;
import java.util.Map;

@WorkerThread
public class DanglingNetworkLogCacheHandlerImpl
implements DanglingNetworkLogCacheHandler {
    private final Logger logger = ServiceLocator.getApmLogger();
    @NonNull
    private final Provider<DatabaseManager> databaseManagerProvider;

    public DanglingNetworkLogCacheHandlerImpl(@NonNull Provider<DatabaseManager> provider) {
        this.databaseManagerProvider = provider;
    }

    @Nullable
    private DatabaseManager getDatabaseManager() {
        DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.databaseManagerProvider.invoke();
        if (danglingNetworkLogCacheHandlerImpl == null) {
            InstabugSDKLogger.i((String)"IBG-APM", (String)"error while getting the database manager database is null");
        }
        return danglingNetworkLogCacheHandlerImpl;
    }

    private void addAttribute(long l, @NonNull String string, @NonNull String string2) {
        if ((this = this.getDatabaseManager()) != null) {
            ContentValues contentValues;
            ContentValues contentValues2 = contentValues;
            contentValues2();
            contentValues.put("trace_id", Long.valueOf(l));
            contentValues.put("attribute_key", string);
            if (string2 != null) {
                contentValues2.put("attribute_value", string2);
            }
            this.openDatabase().insert("dangling_apm_network_traces_attributes", null, contentValues2);
        }
    }

    private void updateAttribute(long l, String string, String charSequence) {
        if ((danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getDatabaseManager()) != null) {
            StringBuilder stringBuilder;
            ContentValues contentValues;
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = danglingNetworkLogCacheHandlerImpl.openDatabase();
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = contentValues;
            new ContentValues().put("attribute_value", charSequence);
            charSequence = stringBuilder;
            ((StringBuilder)charSequence)();
            String string2 = stringBuilder.append(l).append("").toString();
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = string2;
            stringArray[1] = string;
            sQLiteDatabaseWrapper.update("dangling_apm_network_traces_attributes", (ContentValues)danglingNetworkLogCacheHandlerImpl, "trace_id = ? AND attribute_key= ?", stringArray2);
        }
    }

    private void removeAttribute(long l, String string) {
        if ((object = ((DanglingNetworkLogCacheHandlerImpl)object).getDatabaseManager()) != null) {
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = object;
            Object object = "delete from dangling_apm_network_traces_attributes where trace_id = " + l + " and " + "attribute_key" + " = \"" + string + "\"";
            danglingNetworkLogCacheHandlerImpl.openDatabase().execSQL((String)object);
        }
    }

    private static void extractExternalTraceId(Cursor object, APMNetworkLog aPMNetworkLog) {
        int n = object.getColumnIndex("external_trace_id");
        if (n != -1 && !object.isNull(n)) {
            long l = object.getLong(n);
            object = l == 0L ? null : Long.valueOf(l);
            aPMNetworkLog.setExternalTraceId((Long)object);
        } else {
            aPMNetworkLog.setExternalTraceId(null);
        }
    }

    private static void extractExternalTraceStartTimeMillis(Cursor object, APMNetworkLog aPMNetworkLog) {
        int n = object.getColumnIndex("external_trace_start_time_millis");
        if (n != -1 && !object.isNull(n)) {
            long l = object.getLong(n);
            object = l == 0L ? null : Long.valueOf(l);
            aPMNetworkLog.setExternalTraceStartTimestampMillis((Long)object);
        } else {
            aPMNetworkLog.setExternalTraceStartTimestampMillis(null);
        }
    }

    private static void extractW3CExternalTraceAttributes(Cursor cursor, APMNetworkLog aPMNetworkLog) {
        Cursor cursor2 = cursor;
        int n = cursor2.getColumnIndexOrThrow("is_w3c_trace_id_captured");
        if (cursor2.isNull(n)) {
            aPMNetworkLog.setW3CTraceIdCaptured(null);
        } else {
            aPMNetworkLog.setW3CTraceIdCaptured(cursor.getInt(n) != 0);
        }
        Cursor cursor3 = cursor;
        n = cursor3.getColumnIndexOrThrow("w3c_trace_id_pid");
        if (cursor3.isNull(n)) {
            aPMNetworkLog.setGeneratedW3CPid(null);
        } else {
            aPMNetworkLog.setGeneratedW3CPid(cursor.getLong(n));
        }
        Cursor cursor4 = cursor;
        n = cursor4.getColumnIndexOrThrow("w3c_trace_id_timestamp");
        if (cursor4.isNull(n)) {
            aPMNetworkLog.setGeneratedW3CTimestampSeconds(null);
        } else {
            aPMNetworkLog.setGeneratedW3CTimestampSeconds(cursor.getLong(n));
        }
        Cursor cursor5 = cursor;
        n = cursor5.getColumnIndexOrThrow("generated_w3c_trace_id");
        if (cursor5.isNull(n)) {
            aPMNetworkLog.setSyncableGeneratedW3CTraceId(null);
        } else {
            aPMNetworkLog.setSyncableGeneratedW3CTraceId(cursor.getString(n));
        }
        Cursor cursor6 = cursor;
        n = cursor6.getColumnIndexOrThrow("captured_w3c_trace_id");
        if (cursor6.isNull(n)) {
            aPMNetworkLog.setSyncableCapturedW3CTraceId(null);
        } else {
            aPMNetworkLog.setSyncableCapturedW3CTraceId(cursor.getString(n));
        }
    }

    private ContentValues getContentValuesFromNetworkLog(APMNetworkLog aPMNetworkLog, boolean bl) {
        Object object;
        ContentValues contentValues;
        ContentValues contentValues2 = contentValues;
        contentValues = new ContentValues();
        if (aPMNetworkLog.getStartTime() != null) {
            Long l = aPMNetworkLog.getStartTime();
            contentValues2.put("start_time", l);
        }
        if (aPMNetworkLog.getUrl() != null && bl) {
            String string = aPMNetworkLog.getUrl();
            contentValues2.put("url", string);
        }
        if (aPMNetworkLog.getMethod() != null) {
            String string = aPMNetworkLog.getMethod();
            contentValues2.put("method", string);
        }
        if (aPMNetworkLog.getRequestHeaders() != null) {
            String string = aPMNetworkLog.getRequestHeaders();
            contentValues2.put("request_headers", string);
        }
        if (aPMNetworkLog.getRequestContentType() != null) {
            String string = aPMNetworkLog.getRequestContentType();
            contentValues2.put("request_content_type", string);
        }
        if (aPMNetworkLog.getResponseHeaders() != null) {
            String string = aPMNetworkLog.getResponseHeaders();
            contentValues2.put("response_headers", string);
        }
        if (aPMNetworkLog.getResponseContentType() != null) {
            String string = aPMNetworkLog.getResponseContentType();
            contentValues2.put("response_content_type", string);
        }
        if ((object = aPMNetworkLog.getGraphQlQueryName()) != null) {
            contentValues2.put("graph_ql_query_name", (String)object);
        }
        if ((object = aPMNetworkLog.getServerSideErrorMessage()) != null) {
            contentValues2.put("server_side_error_message", (String)object);
        }
        if ((object = aPMNetworkLog.getGrpcMethodName()) != null) {
            contentValues2.put("grpc_method_name", (String)object);
        }
        object = aPMNetworkLog.getTotalDuration();
        contentValues2.put("duration", (Long)object);
        object = aPMNetworkLog.getResponseCode();
        contentValues2.put("response_code", (Integer)object);
        object = aPMNetworkLog.getClientErrorCode();
        contentValues2.put("client_side_error_code", (Integer)object);
        object = aPMNetworkLog.getRequestBodySize();
        contentValues2.put("request_body_size", (Long)object);
        object = aPMNetworkLog.getResponseBodySize();
        contentValues2.put("response_body_size", (Long)object);
        if (aPMNetworkLog.getErrorMessage() != null) {
            object = aPMNetworkLog.getErrorMessage();
            contentValues2.put("error_message", (String)object);
        }
        if (aPMNetworkLog.getRadio() != null) {
            object = aPMNetworkLog.getRadio();
            contentValues2.put("radio", (String)object);
        }
        if (aPMNetworkLog.getCarrier() != null) {
            object = aPMNetworkLog.getCarrier();
            contentValues2.put("carrier", (String)object);
        }
        object = aPMNetworkLog.getExecutedInBackground();
        contentValues2.put("executed_on_background", (Boolean)object);
        object = aPMNetworkLog.isModified();
        contentValues2.put("user_modified", (Boolean)object);
        if (aPMNetworkLog.getLatencySpansJsonString() != null) {
            object = aPMNetworkLog.getLatencySpansJsonString();
            contentValues2.put("network_latency_spans", (String)object);
        }
        this.putW3CExternalTraceAttributes(contentValues2, aPMNetworkLog);
        return contentValues2;
    }

    private void putW3CExternalTraceAttributes(ContentValues contentValues, APMNetworkLog aPMNetworkLog) {
        if (aPMNetworkLog.isW3CTraceIdCaptured() == null) {
            contentValues.putNull("is_w3c_trace_id_captured");
        } else {
            contentValues.put("is_w3c_trace_id_captured", aPMNetworkLog.isW3CTraceIdCaptured());
        }
        if (aPMNetworkLog.getGeneratedW3CPid() == null) {
            contentValues.putNull("w3c_trace_id_pid");
        } else {
            contentValues.put("w3c_trace_id_pid", aPMNetworkLog.getGeneratedW3CPid());
        }
        if (aPMNetworkLog.getGeneratedW3CTimestampSeconds() == null) {
            contentValues.putNull("w3c_trace_id_timestamp");
        } else {
            contentValues.put("w3c_trace_id_timestamp", aPMNetworkLog.getGeneratedW3CTimestampSeconds());
        }
        if (aPMNetworkLog.getSyncableGeneratedW3CTraceId() == null) {
            contentValues.putNull("generated_w3c_trace_id");
        } else {
            contentValues.put("generated_w3c_trace_id", aPMNetworkLog.getSyncableGeneratedW3CTraceId());
        }
        if (aPMNetworkLog.getSyncableCapturedW3CTraceId() == null) {
            contentValues.putNull("captured_w3c_trace_id");
        } else {
            contentValues.put("captured_w3c_trace_id", aPMNetworkLog.getSyncableCapturedW3CTraceId());
        }
    }

    @Override
    public long insertNetworkLog(APMNetworkLog aPMNetworkLog) {
        DatabaseManager databaseManager = danglingNetworkLogCacheHandlerImpl.getDatabaseManager();
        if (databaseManager != null) {
            databaseManager = databaseManager.openDatabase();
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getContentValuesFromNetworkLog(aPMNetworkLog, true);
            long l = databaseManager.insert("dangling_apm_network_log", null, (ContentValues)danglingNetworkLogCacheHandlerImpl);
            databaseManager.close();
            return l;
        }
        return -1L;
    }

    @Override
    public void updateNetworkLog(APMNetworkLog object) {
        String[] stringArray = danglingNetworkLogCacheHandlerImpl.getDatabaseManager();
        if (stringArray != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = stringArray.openDatabase();
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getContentValuesFromNetworkLog((APMNetworkLog)object, false);
            object = String.valueOf(object.getId());
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = object;
            sQLiteDatabaseWrapper.update("dangling_apm_network_log", (ContentValues)danglingNetworkLogCacheHandlerImpl, "log_id = ?", stringArray);
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void cleanUp() {
        if ((this = this.getDatabaseManager()) != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.openDatabase();
            sQLiteDatabaseWrapper.execSQL("delete from dangling_apm_network_log where response_code = 0 and error_message is NULL");
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void trimToLimit(long l) {
        if ((object = ((DanglingNetworkLogCacheHandlerImpl)object).getDatabaseManager()) != null) {
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = object;
            Object object = "delete from dangling_apm_network_log where log_id not in ( select log_id from dangling_apm_network_log order by log_id desc limit " + l + " )";
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = danglingNetworkLogCacheHandlerImpl.openDatabase();
            sQLiteDatabaseWrapper.execSQL((String)object);
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public List<APMNetworkLog> getNetworkLogsByLimit(long var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [7, 6 : 88->93)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteNetworkLogsByLimit(int n) {
        if ((object = ((DanglingNetworkLogCacheHandlerImpl)object).getDatabaseManager()) != null) {
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = object;
            Object object = "delete from dangling_apm_network_log where log_id in (select log_id from dangling_apm_network_log limit " + n + ")";
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = danglingNetworkLogCacheHandlerImpl.openDatabase();
            sQLiteDatabaseWrapper.execSQL((String)object);
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void removeAll() {
        if ((this = this.getDatabaseManager()) != null) {
            SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this.openDatabase();
            sQLiteDatabaseWrapper.execSQL("delete from dangling_apm_network_log");
            sQLiteDatabaseWrapper.close();
        }
    }

    @Override
    public void removeGraphQlData() {
        if ((danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getDatabaseManager()) != null) {
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.openDatabase();
            String string = "UPDATE dangling_apm_network_log SET graph_ql_query_name = NULL,server_side_error_message = NULL WHERE graph_ql_query_name IS NOT NULL";
            if (danglingNetworkLogCacheHandlerImpl != null) {
                DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl2 = danglingNetworkLogCacheHandlerImpl;
                danglingNetworkLogCacheHandlerImpl2.execSQL(string);
                danglingNetworkLogCacheHandlerImpl2.close();
            }
        }
    }

    @Override
    public void removeGrpcData() {
        if ((this = this.getDatabaseManager()) != null && (this = this.openDatabase()) != null) {
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = this;
            danglingNetworkLogCacheHandlerImpl.delete("dangling_apm_network_log", "grpc_method_name IS NOT NULL", null);
            danglingNetworkLogCacheHandlerImpl.close();
        }
    }

    @Override
    public void addAttribute(long l, @NonNull String string, @NonNull String string2, @Nullable String string3) {
        if (string3 == null) {
            ((DanglingNetworkLogCacheHandlerImpl)((Object)string4)).removeAttribute(l, string2);
            return;
        }
        Map<String, String> map = ((DanglingNetworkLogCacheHandlerImpl)((Object)string4)).getTraceAttributes(l);
        if (map != null && map.get(string2) != null) {
            ((DanglingNetworkLogCacheHandlerImpl)((Object)string4)).updateAttribute(l, string2, string3);
        } else {
            int n = ServiceLocator.getApmConfigurationProvider().getNetworkLogsStoreAttributesLimit();
            if (map != null && map.size() == n) {
                DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = string4;
                String string4 = "Trace attribute \"$s1\" wasn't added to \"$s2\". Max allowed trace attributes reached. Please note that you can add up to \"$s3\" attributes to the same trace.".replace("$s1", string2).replace("$s2", string).replace("$s3", n + "");
                danglingNetworkLogCacheHandlerImpl.logger.logSDKError(string4);
            } else {
                ((DanglingNetworkLogCacheHandlerImpl)((Object)string4)).addAttribute(l, string2, string3);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @SuppressLint(value={"Range"})
    @Nullable
    public Map<String, String> getTraceAttributes(long var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [9, 8 : 135->141)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void clearW3CExternalTraceIdCache() {
        ContentValues contentValues;
        if ((danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getDatabaseManager()) == null) {
            return;
        }
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = danglingNetworkLogCacheHandlerImpl.openDatabase();
        DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = contentValues;
        new ContentValues().putNull("is_w3c_trace_id_captured");
        danglingNetworkLogCacheHandlerImpl.putNull("w3c_trace_id_pid");
        danglingNetworkLogCacheHandlerImpl.putNull("w3c_trace_id_timestamp");
        danglingNetworkLogCacheHandlerImpl.putNull("generated_w3c_trace_id");
        danglingNetworkLogCacheHandlerImpl.putNull("captured_w3c_trace_id");
        try {
            sQLiteDatabaseWrapper.update("dangling_apm_network_log", (ContentValues)danglingNetworkLogCacheHandlerImpl, null, null);
        }
        catch (Throwable throwable) {
            IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)("Error occurred while clearing w3c external trace data From DanglingAPMNetworkLog table: " + throwable.getMessage()));
        }
    }

    @Override
    public void clearGeneratedW3CExternalTraceIdCache() {
        ContentValues contentValues;
        if ((danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getDatabaseManager()) == null) {
            return;
        }
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = danglingNetworkLogCacheHandlerImpl.openDatabase();
        DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = contentValues;
        new ContentValues().putNull("generated_w3c_trace_id");
        try {
            sQLiteDatabaseWrapper.update("dangling_apm_network_log", (ContentValues)danglingNetworkLogCacheHandlerImpl, null, null);
        }
        catch (Throwable throwable) {
            IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)("Error occurred while clearing generated w3c external trace id From DanglingAPMNetworkLog table: " + throwable.getMessage()));
        }
    }

    @Override
    public void clearCapturedW3CExternalTraceIdCache() {
        ContentValues contentValues;
        if ((danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl.getDatabaseManager()) == null) {
            return;
        }
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = danglingNetworkLogCacheHandlerImpl.openDatabase();
        DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = contentValues;
        new ContentValues().putNull("captured_w3c_trace_id");
        try {
            sQLiteDatabaseWrapper.update("dangling_apm_network_log", (ContentValues)danglingNetworkLogCacheHandlerImpl, null, null);
        }
        catch (Throwable throwable) {
            IBGDiagnostics.reportNonFatal((Throwable)throwable, (String)("Error occurred while clearing generated captured w3c external trace id From DanglingAPMNetworkLog table: " + throwable.getMessage()));
        }
    }

    @SuppressLint(value={"Range"})
    @VisibleForTesting
    public APMNetworkLog readApmNetworkLogFromCursor(Cursor cursor) {
        DefaultAPMNetworkLog defaultAPMNetworkLog;
        DefaultAPMNetworkLog defaultAPMNetworkLog2 = defaultAPMNetworkLog;
        defaultAPMNetworkLog = new DefaultAPMNetworkLog();
        long l = cursor.getInt(cursor.getColumnIndex("log_id"));
        defaultAPMNetworkLog2.setId(l);
        defaultAPMNetworkLog2.setMethod(cursor.getString(cursor.getColumnIndex("method")));
        defaultAPMNetworkLog2.setCarrier(cursor.getString(cursor.getColumnIndex("carrier")));
        defaultAPMNetworkLog2.setErrorMessage(cursor.getString(cursor.getColumnIndex("error_message")));
        defaultAPMNetworkLog2.setRadio(cursor.getString(cursor.getColumnIndex("radio")));
        l = cursor.getInt(cursor.getColumnIndex("request_body_size"));
        defaultAPMNetworkLog2.setRequestBodySize(l);
        defaultAPMNetworkLog2.setRequestContentType(cursor.getString(cursor.getColumnIndex("request_content_type")));
        defaultAPMNetworkLog2.setRequestHeaders(cursor.getString(cursor.getColumnIndex("request_headers")));
        l = cursor.getInt(cursor.getColumnIndex("response_body_size"));
        defaultAPMNetworkLog2.setResponseBodySize(l);
        defaultAPMNetworkLog2.setResponseCode(cursor.getInt(cursor.getColumnIndex("response_code")));
        defaultAPMNetworkLog2.setClientErrorCode(cursor.getInt(cursor.getColumnIndex("client_side_error_code")));
        defaultAPMNetworkLog2.setResponseContentType(cursor.getString(cursor.getColumnIndex("response_content_type")));
        defaultAPMNetworkLog2.setResponseHeaders(cursor.getString(cursor.getColumnIndex("response_headers")));
        defaultAPMNetworkLog2.setStartTime(cursor.getLong(cursor.getColumnIndex("start_time")));
        l = cursor.getInt(cursor.getColumnIndex("duration"));
        defaultAPMNetworkLog2.setTotalDuration(l);
        defaultAPMNetworkLog2.setUrl(cursor.getString(cursor.getColumnIndex("url")));
        boolean bl = cursor.getInt(cursor.getColumnIndex("executed_on_background")) == 1;
        defaultAPMNetworkLog2.setExecutedInBackground(bl);
        bl = cursor.getInt(cursor.getColumnIndex("user_modified")) == 1;
        defaultAPMNetworkLog2.setModified(bl);
        defaultAPMNetworkLog2.setGraphQlQueryName(cursor.getString(cursor.getColumnIndex("graph_ql_query_name")));
        defaultAPMNetworkLog2.setGrpcMethodName(cursor.getString(cursor.getColumnIndex("grpc_method_name")));
        defaultAPMNetworkLog2.setServerSideErrorMessage(cursor.getString(cursor.getColumnIndex("server_side_error_message")));
        defaultAPMNetworkLog2.setLatencySpansJsonString(cursor.getString(cursor.getColumnIndex("network_latency_spans")));
        DanglingNetworkLogCacheHandlerImpl.extractExternalTraceId(cursor, defaultAPMNetworkLog2);
        DanglingNetworkLogCacheHandlerImpl.extractExternalTraceStartTimeMillis(cursor, defaultAPMNetworkLog2);
        DanglingNetworkLogCacheHandlerImpl.extractW3CExternalTraceAttributes(cursor, defaultAPMNetworkLog2);
        return defaultAPMNetworkLog2;
    }

    @Override
    public void clearNetworkSpansData() {
        if ((danglingNetworkLogCacheHandlerImpl2 = danglingNetworkLogCacheHandlerImpl2.getDatabaseManager()) != null && (danglingNetworkLogCacheHandlerImpl2 = danglingNetworkLogCacheHandlerImpl2.openDatabase()) != null) {
            ContentValues contentValues;
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl = danglingNetworkLogCacheHandlerImpl2;
            DanglingNetworkLogCacheHandlerImpl danglingNetworkLogCacheHandlerImpl2 = contentValues;
            new ContentValues().putNull("network_latency_spans");
            danglingNetworkLogCacheHandlerImpl.update("dangling_apm_network_log", (ContentValues)danglingNetworkLogCacheHandlerImpl2, null, null);
        }
    }
}

