/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm.appflow.usecases;

import com.instabug.apm.appflow.handler.AppFlowHandler;
import com.instabug.apm.appflow.log.LoggerExtKt;
import com.instabug.apm.appflow.usecases.UseCase;
import com.instabug.apm.appflow.validate.SanitizerKtxKt;
import com.instabug.apm.appflow.validate.ValidatorKtxKt;
import com.instabug.apm.di.Provider;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.TimeCaptureBoundModel;
import com.instabug.apm.model.TimeCaptureBoundModelKt;
import com.instabug.apm.sanitization.Sanitizer;
import com.instabug.apm.sanitization.Validator;
import com.instabug.library.core.eventbus.AppStateEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001Bi\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\r\u0012\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0001\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u00042\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0096\u0002J\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0013H\u0002J\u0014\u0010\u001d\u001a\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0002R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/instabug/apm/appflow/usecases/StartAppFlowUseCase;", "Lcom/instabug/apm/appflow/usecases/UseCase;", "Lcom/instabug/apm/model/TimeCaptureBoundModel;", "", "", "handler", "Lcom/instabug/apm/appflow/handler/AppFlowHandler;", "logger", "Lcom/instabug/apm/logger/internal/Logger;", "configurationsValidator", "Lcom/instabug/apm/sanitization/Validator;", "flowNameValidator", "flowNameSanitizer", "Lcom/instabug/apm/sanitization/Sanitizer;", "appStateProvider", "Lcom/instabug/apm/di/Provider;", "Lcom/instabug/library/core/eventbus/AppStateEvent;", "refreshBackgroundFlowUseCase", "", "", "(Lcom/instabug/apm/appflow/handler/AppFlowHandler;Lcom/instabug/apm/logger/internal/Logger;Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/sanitization/Validator;Lcom/instabug/apm/sanitization/Sanitizer;Lcom/instabug/apm/di/Provider;Lcom/instabug/apm/appflow/usecases/UseCase;)V", "forceAbandonFlowAndLogIfActive", "nameModel", "(Lcom/instabug/apm/model/TimeCaptureBoundModel;)Lkotlin/Unit;", "invoke", "param", "startNewAppFlow", "(Lcom/instabug/apm/model/TimeCaptureBoundModel;)Ljava/lang/Boolean;", "validateConfigurations", "isBackground", "instabug-apm_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nStartAppFlowUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartAppFlowUseCase.kt\ncom/instabug/apm/appflow/usecases/StartAppFlowUseCase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class StartAppFlowUseCase
implements UseCase<TimeCaptureBoundModel<String>, Unit> {
    @NotNull
    private final AppFlowHandler handler;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Validator<Unit> configurationsValidator;
    @NotNull
    private final Validator<String> flowNameValidator;
    @NotNull
    private final Sanitizer<String> flowNameSanitizer;
    @NotNull
    private final Provider<AppStateEvent> appStateProvider;
    @NotNull
    private final UseCase<Long, Boolean> refreshBackgroundFlowUseCase;

    public StartAppFlowUseCase(@NotNull AppFlowHandler appFlowHandler, @NotNull Logger logger2, @NotNull Validator<Unit> validator, @NotNull Validator<String> validator2, @NotNull Sanitizer<String> sanitizer, @NotNull Provider<AppStateEvent> provider, @NotNull UseCase<Long, Boolean> useCase) {
        Intrinsics.checkNotNullParameter((Object)appFlowHandler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(validator, (String)"configurationsValidator");
        Intrinsics.checkNotNullParameter(validator2, (String)"flowNameValidator");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"flowNameSanitizer");
        Intrinsics.checkNotNullParameter(provider, (String)"appStateProvider");
        Intrinsics.checkNotNullParameter(useCase, (String)"refreshBackgroundFlowUseCase");
        this.handler = appFlowHandler;
        this.logger = logger2;
        this.configurationsValidator = validator;
        this.flowNameValidator = validator2;
        this.flowNameSanitizer = sanitizer;
        this.appStateProvider = provider;
        this.refreshBackgroundFlowUseCase = useCase;
    }

    private final boolean validateConfigurations() {
        return this.configurationsValidator.isValid(Unit.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Unit forceAbandonFlowAndLogIfActive(TimeCaptureBoundModel<String> object) {
        Boolean bl = this.handler.endWithReason((String)(object = (String)((TimeCaptureBoundModel)object).getModel()), 2);
        if (bl == null) return null;
        if (bl == false) return null;
        if (bl == null) return null;
        if (object == null) return null;
        LoggerExtKt.logForceAbandonedFlow(this.logger, (String)object);
        Unit unit = Unit.INSTANCE;
        return unit;
    }

    private final Boolean startNewAppFlow(TimeCaptureBoundModel<String> timeCaptureBoundModel) {
        StartAppFlowUseCase startAppFlowUseCase = string;
        TimeCaptureBoundModel<String> timeCaptureBoundModel2 = timeCaptureBoundModel;
        String string = timeCaptureBoundModel2.getModel();
        long l = timeCaptureBoundModel2.getTimeCapture().getTimeStampMicro();
        long l2 = timeCaptureBoundModel2.getTimeCapture().getMicroTime();
        boolean bl = startAppFlowUseCase.isBackground(startAppFlowUseCase.appStateProvider);
        return ((StartAppFlowUseCase)((Object)string)).handler.start(string, l, l2, bl);
    }

    private final boolean isBackground(Provider<AppStateEvent> provider) {
        StartAppFlowUseCase startAppFlowUseCase = provider.invoke();
        return startAppFlowUseCase != null ? startAppFlowUseCase instanceof AppStateEvent.BackgroundAppStateEvent : true;
    }

    @Override
    public void invoke(@NotNull TimeCaptureBoundModel<String> timeCaptureBoundModel) {
        Intrinsics.checkNotNullParameter(timeCaptureBoundModel, (String)"param");
        StartAppFlowUseCase startAppFlowUseCase = this.validateConfigurations() ? this : null;
        if (startAppFlowUseCase != null) {
            if (!ValidatorKtxKt.isBoundModelValid(this.flowNameValidator, timeCaptureBoundModel)) {
                timeCaptureBoundModel = null;
            }
            if (timeCaptureBoundModel != null && (timeCaptureBoundModel = SanitizerKtxKt.sanitizeBoundModel(this.flowNameSanitizer, timeCaptureBoundModel)) != null && (timeCaptureBoundModel = TimeCaptureBoundModelKt.takeIfModelNotNull(timeCaptureBoundModel)) != null) {
                this.refreshBackgroundFlowUseCase.invoke(timeCaptureBoundModel.getTimeCapture().getTimeStampMillis());
                this.forceAbandonFlowAndLogIfActive(timeCaptureBoundModel);
                this.startNewAppFlow(timeCaptureBoundModel);
            }
        }
    }
}

