/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.apm;

import android.app.Activity;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.instabug.apm.appflow.di.AppFlowServiceLocator;
import com.instabug.apm.appflow.manager.AppFlowManager;
import com.instabug.apm.appflow.model.AppFlowAttribute;
import com.instabug.apm.attributes.listeners.OnNetworkTraceListener;
import com.instabug.apm.compose.compose_spans.ComposeSpansManager;
import com.instabug.apm.compose.compose_spans.ComposeSpansServiceLocator;
import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.configuration.APMStateProvider;
import com.instabug.apm.configuration.cp.APMCPConfigurationProvider;
import com.instabug.apm.configuration.cp.FeatureAvailabilityCallback;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.eventbus.APMSdkStateEventBus;
import com.instabug.apm.fragment.FragmentSpansHelper;
import com.instabug.apm.handler.applaunch.AppLaunchesHandler;
import com.instabug.apm.handler.executiontraces.ExecutionTracesHandler;
import com.instabug.apm.handler.fragment.FragmentSpansHandler;
import com.instabug.apm.handler.networklog.NetworkLogHandler;
import com.instabug.apm.handler.uitrace.customuitraces.CustomUiTraceHandler;
import com.instabug.apm.lifecycle.AppLaunchLifeCycleCallbacks;
import com.instabug.apm.logger.internal.Logger;
import com.instabug.apm.model.EventTimeMetricCapture;
import com.instabug.apm.model.ExecutionTrace;
import com.instabug.apm.model.TimeCaptureBoundModel;
import com.instabug.apm.sanitization.AsyncSanitizer;
import com.instabug.apm.screenloading.di.ScreenLoadingServiceLocator;
import com.instabug.apm.screenloading.manager.ScreenLoadingManager;
import com.instabug.apm.uitrace.di.UiTracesServiceLocator;
import com.instabug.apm.uitrace.manager.UiTracesManager;
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager;
import com.instabug.library.BuildFieldsProvider;
import com.instabug.library.logging.listeners.networklogs.NetworkLogListener;
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.threading.PoolProvider;

public class APMImplementation {
    private final Logger apmLogger;

    public APMImplementation(Logger logger2) {
        this.apmLogger = logger2;
    }

    private void validateAndSetAppLaunchEnabled(String string, boolean bl) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        String string2 = this.getPrintableAppLaunchType(string);
        String string3 = bl ? "enabled" : "disabled";
        if (!aPMConfigurationProvider.isAPMSdkEnabled()) {
            this.apmLogger.logSDKError("\"$s1\" App launch wasn't \"$s2\". Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm".replace("\"$s1\"", string2).replace("\"$s2\"", string3));
        } else if (!aPMConfigurationProvider.isAPMFeatureAvailable()) {
            this.apmLogger.logSDKError("\"$s1\" App launch wasn't \"$s2\" as APM seems to be disabled for your Instabug company account. Please contact support for more information.".replace("\"$s1\"", string2).replace("\"$s2\"", string3));
        } else if (!this.isAppLaunchFeatureEnabled(string)) {
            this.apmLogger.logSDKError("\"$s1\" App launch wasn't \"$s2\" as the feature seems to be disabled for your Instabug company account. Please contact support for more information.".replace("\"$s1\"", string2).replace("\"$s2\"", string3));
        } else {
            this.setAppLaunchSdkEnabled(string, bl);
            if (!bl) {
                this.clearAppLaunchesCache(string, true);
            }
        }
    }

    private String getPrintableAppLaunchType(String string) {
        if ("cold".equals(string)) {
            return "Cold";
        }
        if ("hot".equals(string)) {
            return "Hot";
        }
        return "Warm";
    }

    private boolean isAppLaunchFeatureEnabled(String string) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if ("cold".equals(string)) {
            return aPMConfigurationProvider.isColdAppLaunchesFeatureEnabled();
        }
        if ("hot".equals(string)) {
            return aPMConfigurationProvider.isHotAppLaunchesFeatureEnabled();
        }
        return aPMConfigurationProvider.isWarmAppLaunchFeatureEnabled();
    }

    private void setAppLaunchSdkEnabled(String string, boolean bl) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if ("cold".equals(string)) {
            aPMConfigurationProvider.setColdAppLaunchSDKEnabled(bl);
        } else if ("hot".equals(string)) {
            aPMConfigurationProvider.setHotAppLaunchSDKEnabled(bl);
        } else if ("warm".equals(string)) {
            aPMConfigurationProvider.setWarmAppLaunchSdkEnabled(bl);
        }
    }

    private static void onAutomaticUiTracesStateChanged() {
        UiTracesManager uiTracesManager = UiTracesServiceLocator.getManager();
        if (uiTracesManager != null) {
            uiTracesManager.onStateChanged();
        }
    }

    private static void onScreenLoadingStateChanged() {
        ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
        if (screenLoadingManager != null) {
            screenLoadingManager.onStateChanged();
        }
    }

    private void onFragmentSpansSdkStateChanged(boolean bl) {
        FragmentSpansHelper fragmentSpansHelper = ServiceLocator.getFragmentSpansHelper();
        if (bl) {
            fragmentSpansHelper.startFragmentsLifecycleCapturing();
        } else {
            fragmentSpansHelper.onFeatureDisabled();
        }
    }

    @Nullable
    private static AppFlowManager getAppFlowManager() {
        return AppFlowServiceLocator.INSTANCE.getManager();
    }

    private void executeOnCpUiExecutor(Runnable runnable) {
        PoolProvider.postOrderedIOTask((String)"cp-ui-executor", (Runnable)runnable);
    }

    public void setEnabled(boolean bl) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (!aPMConfigurationProvider.isAPMFeatureAvailable() && bl) {
            this.apmLogger.logSDKError("APM wasn't enabled as it seems to be disabled for your Instabug company account. Please, contact support to switch it on for you.");
        } else {
            aPMConfigurationProvider.setAPMSdkEnabled(bl);
            APMSdkStateEventBus.INSTANCE.post(bl);
            if (!bl) {
                this.clearCache();
                ServiceLocator.reset();
            }
        }
    }

    public void clearCache() {
        APMImplementation aPMImplementation = this;
        aPMImplementation.clearExecutionTracesCache();
        aPMImplementation.clearAppLaunchesCache();
        aPMImplementation.clearNetworkCache();
        aPMImplementation.clearFragmentSpansCache();
        aPMImplementation.clearApmState();
    }

    public void clearFragmentSpansCache() {
        FragmentSpansHandler fragmentSpansHandler = ServiceLocator.getFragmentSpansHandler();
        if (fragmentSpansHandler != null) {
            fragmentSpansHandler.clearCache();
        }
    }

    public void clearNetworkCache() {
        final NetworkLogHandler networkLogHandler = ServiceLocator.getNetworkLogHandler();
        ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                networkLogHandler.removeAll();
            }
        });
    }

    public void clearGraphQlCache() {
        final NetworkLogHandler networkLogHandler = ServiceLocator.getNetworkLogHandler();
        if (networkLogHandler != null) {
            ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(new Runnable(){

                @Override
                public void run() {
                    networkLogHandler.removeGraphQlData();
                }
            });
        }
    }

    public void clearGrpcCache() {
        NetworkLogHandler networkLogHandler = ServiceLocator.getNetworkLogHandler();
        if (networkLogHandler != null) {
            ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(networkLogHandler::removeGrpcData);
        }
    }

    public void clearNetworkSpansCache() {
        NetworkLogHandler networkLogHandler = ServiceLocator.getNetworkLogHandler();
        if (networkLogHandler != null) {
            ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(networkLogHandler::clearNetworkSpansData);
        }
    }

    public void clearW3CNetworkExternalTraceIdCache() {
        ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(ServiceLocator.getNetworkLogHandler()::clearW3CExternalTraceIdCache);
    }

    public void clearGeneratedW3CExternalTraceIdCache() {
        ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(ServiceLocator.getNetworkLogHandler()::clearGeneratedW3CExternalTraceIdCache);
    }

    public void clearCapturedW3CExternalTraceIdCache() {
        ServiceLocator.getSingleThreadPoolExecutor("network_log_thread_executor").execute(ServiceLocator.getNetworkLogHandler()::clearCapturedW3CExternalTraceIdCache);
    }

    public void clearExecutionTracesCache() {
        final ExecutionTracesHandler executionTracesHandler = ServiceLocator.getExecutionTracesHandler();
        ServiceLocator.getSingleThreadPoolExecutor("execution_traces_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                executionTracesHandler.removeAll();
            }
        });
    }

    public void clearAppLaunchesCache(@NonNull String string) {
        this.clearAppLaunchesCache(string, false);
    }

    public void clearAppLaunchesCache(final @NonNull String string, final boolean bl) {
        final AppLaunchesHandler appLaunchesHandler = ServiceLocator.getAppLaunchesHandler();
        ServiceLocator.getSingleThreadPoolExecutor("app_launch_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                4 v0 = string2;
                String string2 = v0.string;
                string2.appLaunchesHandler.removeAppLaunches(string2, v0.bl);
            }
        });
    }

    public void clearAppLaunchesCache() {
        final AppLaunchesHandler appLaunchesHandler = ServiceLocator.getAppLaunchesHandler();
        ServiceLocator.getSingleThreadPoolExecutor("app_launch_thread_executor").execute(new Runnable(){

            @Override
            public void run() {
                appLaunchesHandler.removeAll();
            }
        });
    }

    public void clearApmState() {
        APMStateProvider aPMStateProvider = ServiceLocator.getApmStateProvider();
        if (aPMStateProvider != null) {
            aPMStateProvider.clearState();
        }
    }

    public void setColdAppLaunchEnabled(boolean bl) {
        this.validateAndSetAppLaunchEnabled("cold", bl);
    }

    public void setHotAppLaunchEnabled(boolean bl) {
        this.validateAndSetAppLaunchEnabled("hot", bl);
    }

    public void setWarmAppLaunchEnabled(boolean bl) {
        this.validateAndSetAppLaunchEnabled("warm", bl);
    }

    @Nullable
    public ExecutionTrace startExecutionTrace(@NonNull String string) {
        if (string != null && !string.trim().isEmpty()) {
            String string2 = string.trim();
            if (string2.length() > 150) {
                string2 = string2.substring(0, 150);
                this.apmLogger.logSDKWarning("Execution trace \"$s\" was truncated as it was too long. Please limit trace names to 150 characters.".replace("$s", string));
            }
            return new ExecutionTrace(string2);
        }
        this.apmLogger.logSDKError("Execution trace wasn't created. Execution trace name can't be empty or null.");
        return null;
    }

    public void setAutoUITraceEnabled(boolean bl) {
        if (BuildFieldsProvider.INSTANCE.provideBuildVersion() < 16) {
            this.apmLogger.logSDKError("Could not enable Auto UI Trace. Feature is supported on API level 16 and up only.");
            return;
        }
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (!aPMConfigurationProvider.isAPMEnabled() && bl) {
            this.apmLogger.logSDKError("Auto UI Trace wasn't enabled. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!aPMConfigurationProvider.isUiTraceFeatureEnabled() && bl) {
            this.apmLogger.logSDKError("Auto UI Trace wasn't enabled as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else {
            aPMConfigurationProvider.setUiTraceSdkEnabled(bl);
        }
        APMImplementation.onAutomaticUiTracesStateChanged();
        APMImplementation.onScreenLoadingStateChanged();
    }

    @RequiresApi(api=16)
    void startUiTrace(final @NonNull String string, final @Nullable Looper looper) {
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                if (BuildFieldsProvider.INSTANCE.provideBuildVersion() < 16) {
                    return;
                }
                Object object = object2.string;
                if (object != null && !((String)object).trim().isEmpty()) {
                    Object object2;
                    if (object2.looper != Looper.getMainLooper()) {
                        object2 = object2.string;
                        object2.APMImplementation.this.apmLogger.e("Custom UI Trace \"$name\" wasn't started as it was called from a non-main thread. Please make sure to start Custom UI Traces from the main thread.".replace("$name", (CharSequence)object2));
                        return;
                    }
                    object = ServiceLocator.getApmConfigurationProvider();
                    if (!object.isAPMEnabled()) {
                        object2 = object2.string;
                        object2.APMImplementation.this.apmLogger.e("Custom UI Trace \"$s\" wasn't started. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm".replace("$s", (CharSequence)object2));
                    } else if (!object.isUiHangsFeatureEnabled()) {
                        object2 = object2.string;
                        object2.APMImplementation.this.apmLogger.e("Custom UI Trace \"$s\" wasn't started as the feature seems to be disabled for your Instabug company account. Please contact support for more information.".replace("$s", (CharSequence)object2));
                    } else {
                        CustomUiTraceHandler customUiTraceHandler;
                        Object object3;
                        object = object2.string.trim();
                        if (((String)object).length() > 150) {
                            object = ((String)object).substring(0, 150);
                            object3 = object2.string;
                            object2.APMImplementation.this.apmLogger.logSDKWarning("Custom UI Trace \"$s\" was truncated as it was too long. Please limit trace names to 150 characters.".replace("$s", (CharSequence)object3));
                        }
                        if ((object3 = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity()) != null && (customUiTraceHandler = ServiceLocator.getCustomUiTraceHandler()) != null) {
                            object2 = object2.looper;
                            customUiTraceHandler.startUiTrace((String)object, (Activity)object3, (Looper)object2);
                        }
                    }
                    return;
                }
                object2.APMImplementation.this.apmLogger.logSDKError("Custom UI Trace wasn't created. Trace name can't be empty or null.");
            }
        });
    }

    @RequiresApi(api=16)
    void endUiTrace(final Looper looper) {
        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

            @Override
            public void run() {
                Activity activity;
                if (BuildFieldsProvider.INSTANCE.provideBuildVersion() < 16) {
                    return;
                }
                CustomUiTraceHandler customUiTraceHandler = ServiceLocator.getCustomUiTraceHandler();
                if (customUiTraceHandler != null && customUiTraceHandler.getCurrentUiTrace() != null && (activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity()) != null) {
                    customUiTraceHandler.endUiTrace(activity, looper);
                    return;
                }
                APMImplementation.this.apmLogger.logSDKError("Custom UI Trace wasn't ended. Please make sure to start a UI Trace first by following the instructions at this link: https://docs.instabug.com/reference#start-ui-trace");
            }
        });
    }

    public void addOnNetworkTraceListener(OnNetworkTraceListener onNetworkTraceListener) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (!aPMConfigurationProvider.isAPMFeatureAvailable()) {
            this.apmLogger.logSDKError("addOnNetworkTraceListener wasn't called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else if (!aPMConfigurationProvider.isAPMEnabled()) {
            this.apmLogger.logSDKError("addOnNetworkTraceListener wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!aPMConfigurationProvider.isNetworkFeatureEnabled()) {
            this.apmLogger.logSDKError("addOnNetworkTraceListener wasn't called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else {
            ServiceLocator.getNetworkTraceAttributesHandler().add(onNetworkTraceListener);
        }
    }

    public void removeOnNetworkTraceListener(OnNetworkTraceListener onNetworkTraceListener) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (!aPMConfigurationProvider.isAPMFeatureAvailable()) {
            this.apmLogger.logSDKError("removeOnNetworkTraceListener wasn't called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else if (!aPMConfigurationProvider.isAPMEnabled()) {
            this.apmLogger.logSDKError("removeOnNetworkTraceListener wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!aPMConfigurationProvider.isNetworkFeatureEnabled()) {
            this.apmLogger.logSDKError("removeOnNetworkTraceListener wasn't called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else {
            ServiceLocator.getNetworkTraceAttributesHandler().remove(onNetworkTraceListener);
        }
    }

    public void endAppLaunch() {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (!aPMConfigurationProvider.isAPMSdkEnabled()) {
            ((APMImplementation)((Object)appLaunchLifeCycleCallbacks)).apmLogger.logSDKError("endAppLaunch() wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!aPMConfigurationProvider.isAPMFeatureAvailable()) {
            ((APMImplementation)((Object)appLaunchLifeCycleCallbacks)).apmLogger.logSDKError("endAppLaunch() wasn't called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else {
            AppLaunchLifeCycleCallbacks appLaunchLifeCycleCallbacks = ServiceLocator.getAppLaunchLifeCycleCallbacks();
            if (appLaunchLifeCycleCallbacks != null) {
                appLaunchLifeCycleCallbacks.endAppLaunch();
            }
        }
    }

    public void setUIHangEnabled(boolean bl) {
        if (BuildFieldsProvider.INSTANCE.provideBuildVersion() < 16) {
            this.apmLogger.logSDKError("Could not enable UI Hangs. Feature is supported on API level 16 and up only.");
            return;
        }
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (aPMConfigurationProvider == null) {
            this.apmLogger.logSDKError("Could not enable UI Hangs. apm configuration provider is null");
            return;
        }
        if (!aPMConfigurationProvider.isAPMEnabled() && bl) {
            this.apmLogger.logSDKError("Auto UI Hangs wasn't enabled. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!aPMConfigurationProvider.isUiHangsFeatureEnabled() && bl) {
            this.apmLogger.logSDKError("Auto UI Hangs wasn't enabled as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else if (!aPMConfigurationProvider.isUiTraceSdkEnabled() && bl) {
            this.apmLogger.logSDKError("Auto UI Hangs wasn\u2019t enabled as Auto UI Traces seems to be disabled. Please make sure to enable Auto UI Traces first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-auto-ui-traces");
        } else {
            aPMConfigurationProvider.setUiHangsSdkEnabled(bl);
        }
        APMImplementation.onAutomaticUiTracesStateChanged();
    }

    public void setScreenLoadingEnabled(boolean bl) {
        if (BuildFieldsProvider.INSTANCE.provideBuildVersion() < 16) {
            this.apmLogger.logSDKError("Could not enable UI loading. Feature is supported on API level 16 and up only.");
            return;
        }
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (aPMConfigurationProvider == null) {
            this.apmLogger.logSDKError("Could not enable UI loading. apm configuration provider is null");
            return;
        }
        if (!aPMConfigurationProvider.isAPMEnabled() && bl) {
            this.apmLogger.logSDKError("Screen Loading wasn't enabled. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else if (!aPMConfigurationProvider.isUiLoadingMetricsFeatureEnabled() && bl) {
            this.apmLogger.logSDKError("Screen Loading wasn't enabled as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else if (!aPMConfigurationProvider.isUiTraceSdkEnabled() && bl) {
            this.apmLogger.logSDKError("Screen Loading wasn\u2019t enabled as Auto UI Traces seems to be disabled. Please make sure to enable Auto UI Traces first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-auto-ui-traces");
        } else {
            aPMConfigurationProvider.setUiLoadingMetricsSdkEnabled(bl);
        }
        APMImplementation.onScreenLoadingStateChanged();
    }

    public <ActivityType extends Activity> void endScreenLoading(Class<ActivityType> clazz, EventTimeMetricCapture eventTimeMetricCapture) {
        ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
        if (screenLoadingManager != null) {
            screenLoadingManager.endScreenLoading(clazz, eventTimeMetricCapture);
        }
    }

    public void setFragmentSpansEnabled(boolean bl) {
        APMConfigurationProvider aPMConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
        if (!(aPMConfigurationProvider.isAPMFeatureAvailable() && aPMConfigurationProvider.isFragmentSpansFeatureEnabled() || !bl)) {
            this.apmLogger.logSDKError("setFragmentSpansEnabled wasn\u2019t called as the feature seems to be disabled for your Instabug company account. Please contact support for more information.");
        } else if (!aPMConfigurationProvider.isAPMSdkEnabled() && bl) {
            this.apmLogger.logSDKError("setFragmentSpansEnabled wasn't called. Please make sure to enable APM first by following the instructions at this link: https://docs.instabug.com/reference#enable-or-disable-apm");
        } else {
            aPMConfigurationProvider.setFragmentSpansSDKEnabled(bl);
            this.onFragmentSpansSdkStateChanged(bl);
        }
    }

    public void registerNetworkLogsListener(@Nullable NetworkLogListener networkLogListener) {
        ServiceLocator.getNetworkInterceptionRepository().setNetworkLogListener(networkLogListener);
    }

    public void setComposeSpansEnabled(boolean bl) {
        ComposeSpansManager composeSpansManager = ComposeSpansServiceLocator.INSTANCE.getComposeSpansManager();
        if (composeSpansManager != null) {
            composeSpansManager.setSDKEnabled(bl);
        }
    }

    public void setWebViewsTrackingEnabled(boolean bl) {
        WebViewTraceManager webViewTraceManager = ServiceLocator.getWebViewTraceManager();
        if (webViewTraceManager != null) {
            webViewTraceManager.setSDKEnabled(bl);
        }
    }

    public void startFlow(TimeCaptureBoundModel<String> timeCaptureBoundModel) {
        AppFlowManager appFlowManager = APMImplementation.getAppFlowManager();
        if (appFlowManager != null) {
            appFlowManager.startFlow(timeCaptureBoundModel);
        }
    }

    public void endFlow(TimeCaptureBoundModel<String> timeCaptureBoundModel) {
        AppFlowManager appFlowManager = APMImplementation.getAppFlowManager();
        if (appFlowManager != null) {
            appFlowManager.endFlow(timeCaptureBoundModel);
        }
    }

    public void setFlowAttribute(@NonNull TimeCaptureBoundModel<AppFlowAttribute> timeCaptureBoundModel) {
        AppFlowManager appFlowManager = APMImplementation.getAppFlowManager();
        if (appFlowManager != null) {
            appFlowManager.setAttribute(timeCaptureBoundModel);
        }
    }

    public void startUiTraceCP(String string, long l, long l2) {
        this.executeOnCpUiExecutor(() -> {
            Object object = ScreenLoadingServiceLocator.getManager();
            if (object != null) {
                object.cacheCurrentScreenLoadingCP();
            }
            if ((object = UiTracesServiceLocator.getManager()) != null) {
                object.onScreenChanged(string, l, l2);
            }
        });
    }

    public void reportScreenLoadingCP(long l, long l2, long l3) {
        this.executeOnCpUiExecutor(() -> {
            ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
            if (screenLoadingManager != null) {
                Long l4 = l;
                Long l5 = l2;
                Long l6 = l3;
                screenLoadingManager.reportScreenLoadingCP(l4, l5, l6);
            }
        });
    }

    public void endScreenLoadingCP(long l, long l2) {
        this.executeOnCpUiExecutor(() -> {
            ScreenLoadingManager screenLoadingManager = ScreenLoadingServiceLocator.getManager();
            if (screenLoadingManager != null) {
                Long l3 = l;
                screenLoadingManager.endScreenLoadingCP(l3, l2);
            }
        });
    }

    public void isFeatureEnabledCP(String string, String string2, FeatureAvailabilityCallback featureAvailabilityCallback) {
        APMCPConfigurationProvider.INSTANCE.getFeatureAvailability(string, string2, featureAvailabilityCallback);
    }

    public boolean isFeatureEnabledCP(String string, String string2) {
        return APMCPConfigurationProvider.INSTANCE.getFeatureAvailability(string, string2);
    }

    public void registerAsyncNetworkLogSanitizer(AsyncSanitizer<NetworkLogSnapshot> asyncSanitizer) {
        ServiceLocator.getNetworkInterceptionRepository().setAsyncSanitizer(asyncSanitizer);
    }
}

