package com.instabug.apm.webview.webview_trace.model

import android.database.Cursor
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMWebViewTraceEntry
import com.instabug.library.parse.Parser

class WebViewCacheModelToCursorParser : Parser<Cursor?, List<WebViewCacheModel>?> {
    override fun parse(source: Cursor?): List<WebViewCacheModel>? = source?.run {
        ArrayList<WebViewCacheModel>().also {
            while (moveToNext()) it.add(extractWebViewTraceEntryEntry())
        }
    }

    private fun Cursor.extractWebViewTraceEntryEntry() = WebViewCacheModel(
        getString(getColumnIndexOrThrow(APMWebViewTraceEntry.COLUMN_TRACE_URL)),
        getLong(getColumnIndexOrThrow(APMWebViewTraceEntry.COLUMN_START_TIME_STAMP_MICRO)),
        getLong(getColumnIndexOrThrow(APMWebViewTraceEntry.COLUMN_DURATION_MICRO)),
        getInt(getColumnIndexOrThrow(APMWebViewTraceEntry.COLUMN_IS_FULL_SCREEN)) == 1,
        getString(getColumnIndexOrThrow(APMWebViewTraceEntry.COLUMN_VITALS_JSON))
    )
}