package com.instabug.apm.webview.vital

/*
 * Instabug Web Vitals Event Listener
 * This interface is used to listen for web vitals events.
 * It provides methods to handle CLS, FID, and LCP metrics.
 */
interface InstabugWebVitalsEventListener {

    /**
     * Called when the Cumulative Layout Shift (CLS) metric is available.
     * @param value The CLS value.
     */
    fun onCls(value: Double)

    /**
     * Called when the Cumulative Layout Shift (CLS) metric is available.
     * @param value The CLS value.
     */
    fun onFid(value: Double)

    /**
     * Called when the Largest Contentful Paint (LCP) metric is available.
     * @param value The LCP value in milliseconds.
     */
    fun onLCP(value: Double)

    /**
     * Handling errors when the web-vitals script fails to load
     * or when the web-vitals functions are not found
     * @param message error message
     *
     */
    fun onError(message: String) {
        // Default implementation does nothing
        // Subclasses can override this method to handle errors as needed
    }
}