package com.instabug.apm.util.logging;

import androidx.annotation.NonNull;

import com.instabug.apm.logger.internal.Logger;
import com.instabug.library.internal.utils.stability.handler.penalty.PenaltyHandler;
import com.instabug.library.internal.utils.stability.handler.penalty.PenaltyType;

public class APMLogPenaltyHandler implements PenaltyHandler {

    private final Logger logger;

    public APMLogPenaltyHandler(@NonNull Logger apmLogger) {
        this.logger = apmLogger;
    }

    @PenaltyType
    @Override
    public int getPenaltyType() {
        return PenaltyType.LOG;
    }

    @Override
    public void handle(@NonNull Exception e) {
        logger.logSDKError(e.getMessage() == null ? "An Exception has occurred" : e.getMessage(), e);
    }
}
