package com.instabug.apm.networking.mapping.experiment

import com.instabug.apm.cache.model.SessionMetaData
import org.json.JSONArray
import org.json.JSONObject

class ExperimentMapperImpl: ExperimentMapper {
    override fun toJsonObject(experiments: List<String>?, metaData: SessionMetaData?): JSONObject? =
        experiments?.let { _experiments ->
            val droppedCount = metaData?.getDroppedExperimentsCount(_experiments.size) ?: 0
            if (experiments.isNotEmpty() || droppedCount > 0) {
                JSONObject().apply {
                    put(EXPERIMENTS_ARRAY, JSONArray(_experiments))
                    if (droppedCount > 0) {
                        put(DROPPED_EXPERIMENTS_COUNT, droppedCount)
                    }
                }
            } else {
                null
            }
        }
}