package com.instabug.apm.cache.handler.experiment.mapping

import com.instabug.library.map.TwoWayMapper

class ExperimentsCacheTwoWayMapper : TwoWayMapper<List<String>, ByteArray> {

    override fun mapForwards(type1: List<String>): ByteArray =
        type1.joinToString(separator, transform = ::escapeSpecialCharacters).toByteArray()

    override fun mapBackwards(type2: ByteArray): List<String> =
        if (type2.isEmpty())
            emptyList()
        else
            String(type2).split(splitRegex).map(::undoEscapeSpecialCharacters)

    private fun escapeSpecialCharacters(experiments: String): String =
        experiments.replace(backslash, escapedBackslash).replace(separator, escapedSeparator)

    private fun undoEscapeSpecialCharacters(experiments: String): String =
        experiments.replace(escapedSeparator, separator).replace(escapedBackslash, backslash)

    companion object {
        private const val separator = ","
        private const val escapedSeparator = "\\,"
        private const val backslash = "\\"
        private const val escapedBackslash = "\\/\\"
        private val splitRegex = "((?<!\\\\),)|((?<=\\\\/\\\\),)".toRegex()

        @JvmStatic
        fun createInstance(): TwoWayMapper<List<String>, ByteArray> =
            ExperimentsCacheTwoWayMapper()
    }
}