package com.instabug.apm.webview.webview_trace.handler

import com.instabug.apm.webview.webview_trace.flow.WebViewEventFlow
import com.instabug.apm.webview.webview_trace.model.WebViewTraceModel
import com.instabug.apm.webview.webview_trace.model.event.WebViewEvent
import com.instabug.apm.webview.webview_trace.model.event.WebViewLoadUrlEvent
import com.instabug.apm.webview.webview_trace.model.event.WebViewSizeReadyEvent
import com.instabug.apm.webview.webview_trace.model.event.WebViewTraceInitiationEvent
import com.instabug.apm.webview.webview_trace.model.event.WebViewVitalEvent

class WebViewTraceModelWrapper(
    private val flows: WebViewEventFlow,
    private val vitalsFlow: WebViewEventFlow
) {
    var traceModel: WebViewTraceModel? = null
        private set

    fun handleEvent(event: WebViewEvent): WebViewEvent? {
        if (flows.process(event)) {
            if (traceModel == null && event is WebViewTraceInitiationEvent) {
                traceModel = WebViewTraceModel(
                    event.traceId,
                    firstEventTimeCapture = event.timeCapture
                )
            }
            traceModel?.handleEvent(event)
        }
        return flows.getPendingEvent()
    }

    fun shouldRegisterWebVitalsListener(): Boolean = vitalsFlow.finished()

    fun isSizeResolved(): Boolean = traceModel?.isSizeResolved() ?: false

    private fun WebViewTraceModel.handleEvent(event: WebViewEvent) {
        if (event.isTimeBased) {
            lastEventTimeCapture = event.timeCapture
        }
        when(event) {
            is WebViewLoadUrlEvent -> handle(event)
            is WebViewVitalEvent -> handle(event)
            is WebViewSizeReadyEvent -> handle(event)
        }
    }

    private fun WebViewTraceModel.handle(event: WebViewLoadUrlEvent) {
        if (url == null) {
            url = event.url
        }
    }

    private fun WebViewTraceModel.handle(event: WebViewVitalEvent) {
        val vitalsMap =
            vitals ?:
            HashMap<String, Double>().also { vitals = it }
        vitalsMap[event.name] = event.value
    }

    private fun WebViewTraceModel.handle(event: WebViewSizeReadyEvent) {
        if (!this@handle.isSizeResolved()) {
            isFullScreen = event.isFullScreen
        }
    }
}
