package com.instabug.apm.networkinterception.sanitization

import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.constants.ErrorMessages.REMOVING_NETWORK_LOG_URL_IS_NOT_ALLOWED
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.networkinterception.map.applyFromSnapshot
import com.instabug.apm.networkinterception.repository.NetworkInterceptionRepository
import com.instabug.apm.sanitization.Sanitizer
import com.instabug.library.factory.Factory
import com.instabug.library.logging.listeners.networklogs.NetworkLogListener
import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot
import com.instabug.library.map.Mapper

class UserDefinedSanitizerFactory(
    private val apmNetworkLogNetworkSnapshotMapper: Mapper<APMNetworkLog, NetworkLogSnapshot>?,
    private val apmConfigurationProvider: APMConfigurationProvider,
    private val networkInterceptionRepo: NetworkInterceptionRepository,
    private val logger: Logger
) : Factory<Sanitizer<APMNetworkLog>?> {
    override fun create(): Sanitizer<APMNetworkLog>? =
        networkInterceptionRepo.networkLogListener?.takeIf { apmConfigurationProvider.isNetworkEnabled }
            ?.let { listener ->
                apmNetworkLogNetworkSnapshotMapper?.let { mapper ->
                    UserDefinedSanitizer(listener, mapper, logger)
                }
            }
}

class UserDefinedSanitizer(
    private val networkLogListener: NetworkLogListener,
    private val mapper: Mapper<APMNetworkLog, NetworkLogSnapshot>,
    private val logger: Logger
) : Sanitizer<APMNetworkLog> {
    override fun sanitize(item: APMNetworkLog): APMNetworkLog? = networkLogListener
        .onNetworkLogCaptured(mapper.map(item))?.let { snapshot ->
            item.applyFromSnapshot(snapshot)
                .takeIf { it.url != null }
                ?: run {
                    logger.logSDKError(REMOVING_NETWORK_LOG_URL_IS_NOT_ALLOWED)
                    null
                }
        }
}