package com.instabug.apm.networkinterception.sanitization

import androidx.annotation.IntDef
import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.sanitization.CompositeSanitizer
import com.instabug.apm.sanitization.Sanitizer
import com.instabug.library.factory.ParameterizedFactory

@Retention(AnnotationRetention.SOURCE)
@IntDef(
    InterceptorType.OK_HTTP,
    InterceptorType.HTTP_URL_CONNECTION,
    InterceptorType.GRPC,
    InterceptorType.APM_NETWORK_LOGGER
)
annotation class InterceptorType {
    companion object {
        const val OK_HTTP = 1
        const val HTTP_URL_CONNECTION = 2
        const val GRPC = 3
        const val APM_NETWORK_LOGGER = 4
    }
}

class NetworkInterceptionSanitizerFactory(
    private val instabugRequestSanitizerFactory: InstabugRequestSanitizerFactory,
    private val userDefinedSanitizerFactory: UserDefinedSanitizerFactory
) : ParameterizedFactory<Sanitizer<APMNetworkLog>, Int> {

    override fun create(type: Int): Sanitizer<APMNetworkLog> =
        CompositeSanitizer<APMNetworkLog>().apply {
            if (type == InterceptorType.HTTP_URL_CONNECTION)
                addSanitizer(instabugRequestSanitizerFactory.create())
            addSanitizer(userDefinedSanitizerFactory.create())
        }
}