package com.instabug.apm.contentprovider;

import android.app.Application;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.apm.logger.APMLogger;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.customtraces.IBGPendingTraceHandler;


public class APMContentProvider extends ContentProvider {

    @Override
    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        if (context != null && context instanceof Application) {
            try {
                IBGPendingTraceHandler.setApmCPStartTime(System.currentTimeMillis());
                Application application = (Application) context;
                InstabugCore.startVitalComponents(application);
                ServiceLocator.setContext(application);
                APMConfigurationProvider apmConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
                //Register ActivityLifecycleCallbacks when needed only
                boolean isLaunchesEnabled = apmConfigurationProvider.isAppLaunchesEnabled();
                if (isLaunchesEnabled
                        || apmConfigurationProvider.isUiTraceEnabled()) {
                    application.registerActivityLifecycleCallbacks(
                            ServiceLocator.getActivityCallbacks(context, true)
                    );
                }
                IBGPendingTraceHandler.setApmCPEndTime(System.currentTimeMillis());
                ServiceLocator.getAppStateEventDispatcher().start();
                ServiceLocator.getFragmentSpansHelper().startFragmentsLifecycleCapturing();
            } catch (Exception e) {
                APMLogger.logSDKError("Error in content provider: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean onCreate() {
        return false;
    }

    @Nullable
    @Override
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        return null;
    }

    @Nullable
    @Override
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    @Override
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    @Override
    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}
