package com.instabug.apm.cache.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.appflow.model.AppFlowCacheModel;
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel;
import com.instabug.apm.constants.Constants.SessionEndStatusCode;
import com.instabug.apm.constants.Constants.SessionSyncStatus;
import com.instabug.apm.model.APMNetworkLog;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.common.SessionVersion;

import java.util.List;

public class SessionCacheModel implements Session {

    @NonNull
    private final String id;
    @NonNull
    private final String coreId;
    @NonNull
    private final String os;
    @NonNull
    private final String appVersion;
    @NonNull
    private final String uuid;
    private final long duration;
    private final long startTimestampMicros;
    private final long startNanoTime;
    @SessionEndStatusCode
    private final int terminationStatusCode;
    @SessionSyncStatus
    private int syncStatus;
    @Nullable
    private List<AppLaunchCacheModel> appLaunches;
    @Nullable
    private List<ExecutionTraceCacheModel> executionTraces;
    @Nullable
    private List<UiTraceCacheModel> uiTraces;
    @Nullable
    private List<APMNetworkLog> networkLogs;
    @Nullable
    private SessionMetaData sessionMetaData;
    @Nullable
    private List<String> experiments;

    @Nullable
    private List<FragmentSpansCacheModel> fragmentSpans;

    @Nullable
    private List<ComposeSpansCacheModel> composeSpans;

    @Nullable
    private List<AppFlowCacheModel> appFlows;

    @NonNull
    @SessionVersion
    private final String coreSessionVersion;

    public SessionCacheModel(@NonNull String id, @NonNull Session session) {
        this(id, session.getId(), session.getOs(),
                session.getAppVersion() != null ? session.getAppVersion() : "",
                session.getUuid(), 0,
                session.getStartTimestampMicros(), session.getStartNanoTime(),
                session.getVersion(),
                SessionEndStatusCode.UNDEFINED, SessionSyncStatus.UNDEFINED);
    }

    public SessionCacheModel(@NonNull String id, @NonNull String coreId, @NonNull String os,
                             @NonNull String appVersion, @NonNull String uuid, long duration,
                             long startTimestampMicros, long startNanoTime,
                             @NonNull @SessionVersion String coreSessionVersion,
                             @SessionEndStatusCode int terminationStatusCode,
                             @SessionSyncStatus int sessionSyncStatus) {
        this.id = id;
        this.coreId = coreId;
        this.os = os;
        this.appVersion = appVersion;
        this.uuid = uuid;
        this.duration = duration;
        this.startTimestampMicros = startTimestampMicros;
        this.terminationStatusCode = terminationStatusCode;
        this.startNanoTime = startNanoTime;
        this.syncStatus = sessionSyncStatus;
        this.coreSessionVersion = coreSessionVersion;
    }

    @NonNull
    @Override
    public String getId() {
        return id;
    }

    @NonNull
    public String getCoreId() {
        return coreId;
    }

    @NonNull
    @Override
    public String getOs() {
        return os;
    }

    @NonNull
    @Override
    public String getAppVersion() {
        return appVersion;
    }

    @NonNull
    @Override
    public String getUuid() {
        return uuid;
    }

    public long getDuration() {
        return duration;
    }

    @Override
    public long getStartTimestampMicros() {
        return startTimestampMicros;
    }

    @Override
    public long getStartNanoTime() {
        return startNanoTime;
    }

    @SessionVersion
    @Override
    public String getVersion() {
        return coreSessionVersion;
    }

    @SessionEndStatusCode
    public int getTerminationStatusCode() {
        return terminationStatusCode;
    }

    @SessionSyncStatus
    public int getSyncStatus() {
        return syncStatus;
    }

    public void setSyncStatus(@SessionSyncStatus int syncStatus) {
        this.syncStatus = syncStatus;
    }

    @Nullable
    public List<AppLaunchCacheModel> getAppLaunches() {
        return appLaunches;
    }

    public void setAppLaunches(@Nullable List<AppLaunchCacheModel> appLaunches) {
        this.appLaunches = appLaunches;
    }

    @Nullable
    public List<ExecutionTraceCacheModel> getExecutionTraces() {
        return executionTraces;
    }

    public void setExecutionTraces(@Nullable List<ExecutionTraceCacheModel> executionTraces) {
        this.executionTraces = executionTraces;
    }

    @Nullable
    public List<UiTraceCacheModel> getUiTraces() {
        return uiTraces;
    }

    public void setUiTraces(@Nullable List<UiTraceCacheModel> uiTraces) {
        this.uiTraces = uiTraces;
    }

    @Nullable
    public List<APMNetworkLog> getNetworkLogs() {
        return networkLogs;
    }

    public void setNetworkLogs(@Nullable List<APMNetworkLog> networkLogs) {
        this.networkLogs = networkLogs;
    }

    @Nullable
    public SessionMetaData getSessionMetaData() {
        return sessionMetaData;
    }

    public void setSessionMetaData(@Nullable SessionMetaData sessionMetaData) {
        this.sessionMetaData = sessionMetaData;
    }

    @Nullable
    public List<String> getExperiments() {
        return experiments;
    }

    public void setExperiments(@Nullable List<String> experiments) {
        this.experiments = experiments;
    }

    @Nullable
    public List<FragmentSpansCacheModel> getFragmentSpans() {
        return fragmentSpans;
    }

    public void setFragmentSpans(@Nullable List<FragmentSpansCacheModel> fragmentSpans) {
        this.fragmentSpans = fragmentSpans;
    }

    @Nullable
    public List<ComposeSpansCacheModel> getComposeSpans() {
        return composeSpans;
    }

    public void setComposeSpans(@Nullable List<ComposeSpansCacheModel> composeSpans) {
        this.composeSpans = composeSpans;
    }

    public int getWebViewTraceTotalCount() {
        int webViewTraceTotalCount = 0;
        List<UiTraceCacheModel> localTraces = uiTraces;
        if (localTraces != null) {
            for (UiTraceCacheModel uiTrace : localTraces) {
                if (uiTrace == null) continue;
                webViewTraceTotalCount += uiTrace.getWebViewTraceCount();
            }
        }
        return webViewTraceTotalCount;
    }

    @Nullable
    public List<AppFlowCacheModel> getAppFlows() {
        return appFlows;
    }

    public void setAppFlows(@Nullable List<AppFlowCacheModel> appFlows) {
        this.appFlows = appFlows;
    }
}