package com.instabug.apm.appflow

import com.instabug.apm.appflow.usecases.UseCase
import com.instabug.apm.di.Provider
import com.instabug.apm.handler.session.APMSessionObserver
import com.instabug.library.model.common.Session
import java.util.concurrent.Executor

class AppFlowSessionObserver(
    private val executorProvider: Provider<out Executor>,
    private val appFlowNewSessionUseCaseProvider: Provider<UseCase<Pair<Session, Session?>, Unit>?>
) : APMSessionObserver {
    override fun onNewSessionStarted(runningSession: Session, lastSession: Session?) =
        executorProvider().execute {
            appFlowNewSessionUseCaseProvider()?.invoke(runningSession to lastSession)
        }
}