package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewSizeReadyEvent : WebViewEvent {
    val isFullScreen: Boolean

    constructor(
        isFullScreen: Boolean,
        timeCapture: EventTimeMetricCapture = EventTimeMetricCapture(),
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.SIZE_READY,
        timeCapture = timeCapture,
        isTermination = false,
        isTimeBased = false,
        copyCount = copyCount
    ) {
        this.isFullScreen = isFullScreen
    }

    constructor(
        from: WebViewSizeReadyEvent,
        isTerminationOverride: Boolean? = null
    ) : super(from, isTerminationOverride) {
        this.isFullScreen = from.isFullScreen
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewSizeReadyEvent =
        WebViewSizeReadyEvent(this, isTerminationOverride)
}