package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewLoadDataEvent : WebViewEvent, WebViewTraceInitiationEvent {

    override val traceId: Long
    override val shouldInitiateNewTrace = false

    constructor(
        traceId: Long,
        timeCapture: EventTimeMetricCapture,
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.LOAD_DATA,
        timeCapture = timeCapture,
        isTermination = true,
        copyCount = copyCount,
    ) {
        this.traceId = traceId
    }

    constructor(from: WebViewLoadDataEvent, isTerminationOverride: Boolean? = null) :
            super(from, isTerminationOverride) {
        this.traceId = from.traceId
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewLoadDataEvent =
        WebViewLoadDataEvent(this, isTerminationOverride)
}