package com.instabug.apm.webview.webview_trace.model

import android.content.ContentValues
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMWebViewTraceEntry
import com.instabug.library.map.Mapper

class WebViewsCacheContentValuesMapper : Mapper<Pair<WebViewCacheModel, Long>, ContentValues> {
    override fun map(from: Pair<WebViewCacheModel, Long>): ContentValues = ContentValues().apply {
        from.first.apply {
            put(APMWebViewTraceEntry.COLUMN_TRACE_URL, url)
            put(APMWebViewTraceEntry.COLUMN_START_TIME_STAMP_MICRO, startTimeStampMicro)
            put(APMWebViewTraceEntry.COLUMN_DURATION_MICRO, durationMicro)
            put(APMWebViewTraceEntry.COLUMN_VITALS_JSON, vitalsJsonObject)
            put(APMWebViewTraceEntry.COLUMN_IS_FULL_SCREEN, isFulScreen)
        }
        put(APMWebViewTraceEntry.COLUMN_UI_TRACE_ID, from.second)
    }
}