package com.instabug.apm.util.powermanagement;

/**
 Created by Barakat on 19/06/2020
 */
public interface PowerManagementCallback {
    /**
     Listen the battery level change to update the model
     Update only happens if it was battery discharging, not charging
     Meaning if the battery was charging and getting higher levels during a screen visit
     we keep the lowest value we captured.

     @param level int value ot the current battery level
     */
    void onBatteryLevelChanged(int level);

    /**
     Listen the power save mode state change to update the model
     Update only happens if it was changed from false to true, not the opposite
     Meaning if the power save mode was disabled after being enabled withing a screen visit
     we keep the "enabled" value.

     @param enabled true if the state changed to enabled, false if changed to disabled
     */
    void onPowerSaveModeChanged(boolean enabled);
}
