package com.instabug.apm.util

import com.instabug.apm.logger.internal.Logger
import com.instabug.library.diagnostics.IBGDiagnostics

internal inline fun runOrReportAPMError(message: String, logger: Logger, operation: () -> Unit) {
    runCatching { operation() }.onFailure { logger.reportAndLogError(message, it) }
}

internal fun Logger.reportAndLogError(message: String, throwable: Throwable) {
    IBGDiagnostics.reportNonFatal(throwable, message)
    logSDKError(message, throwable)
}