package com.instabug.apm.uitrace.di

import android.os.Build
import android.os.Looper
import androidx.annotation.RequiresApi
import com.instabug.apm.di.Provider
import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.uitrace.UiTraceWrapper
import com.instabug.apm.uitrace.activitycallbacks.APMUiTraceActivityCallbacks
import com.instabug.apm.uitrace.handler.CPAutomaticUiTracesHandlerImpl
import com.instabug.apm.uitrace.handler.UiTraceHandler
import com.instabug.apm.util.powermanagement.BatteryLevelChangeBroadcast
import com.instabug.apm.util.powermanagement.PowerSaveModeBroadcast
import com.instabug.apm.webview.webview_trace.configuration.WebViewTraceConfigurationProvider
import com.instabug.apm.webview.webview_trace.manager.WebViewTraceManager
import com.instabug.library.factory.ParameterizedFactory
import com.instabug.library.util.threading.PoolProvider

class UiTraceHandlerProvider : Provider<UiTraceHandler?> {
    override fun invoke(): UiTraceHandler? =
        UiTracesServiceLocator.handler
}

@RequiresApi(Build.VERSION_CODES.JELLY_BEAN)
class UiTraceWrapperFactoryProvider :
    Provider<ParameterizedFactory<UiTraceWrapper, Long>?> {
    override fun invoke(): ParameterizedFactory<UiTraceWrapper, Long>? =
        UiTracesServiceLocator.wrapperFactory
}

class WebViewTraceManagerProvider : Provider<WebViewTraceManager?> {
    override fun invoke(): WebViewTraceManager? =
        ServiceLocator.getWebViewTraceManager()
}

class WebViewTraceConfigsProvider : Provider<WebViewTraceConfigurationProvider?> {
    override fun invoke(): WebViewTraceConfigurationProvider? =
        ServiceLocator.getWebViewTraceConfigurationProvider()
}

@RequiresApi(Build.VERSION_CODES.JELLY_BEAN)
class BatteryLevelChangeBroadcastProvider : Provider<BatteryLevelChangeBroadcast?> {
    override fun invoke(): BatteryLevelChangeBroadcast? =
        ServiceLocator.getBatteryBroadcastReceiver()
}

class PowerSaveModeBroadcastProvider : Provider<PowerSaveModeBroadcast?> {
    override fun invoke(): PowerSaveModeBroadcast? =
        ServiceLocator.getPowerSaveModeBroadcastReceiver()
}


@RequiresApi(Build.VERSION_CODES.JELLY_BEAN)
class CustomUiTraceHandlerActivityCallbacksProvider : Provider<APMUiTraceActivityCallbacks?> {
    override fun invoke(): APMUiTraceActivityCallbacks? =
            ServiceLocator.getCustomUiTraceHandlerActivityCallbacks()
}

@RequiresApi(Build.VERSION_CODES.JELLY_BEAN)
class NativeAutomaticUiTraceHandlerProvider : Provider<APMUiTraceActivityCallbacks> {
    override fun invoke(): APMUiTraceActivityCallbacks =
        UiTracesServiceLocator.createNativeAutomaticUiTraceHandler()
}

@RequiresApi(Build.VERSION_CODES.JELLY_BEAN)
class CPAutomaticUiTraceHandlerProvider : Provider<CPAutomaticUiTracesHandlerImpl> {
    override fun invoke(): CPAutomaticUiTracesHandlerImpl =
        UiTracesServiceLocator.createCPAutomaticUiTraceHandler()
}