package com.instabug.apm.uitrace

import com.instabug.apm.cache.model.UiTraceCacheModel
import com.instabug.apm.uitrace.uihangs.UiHangHandler
import com.instabug.apm.util.powermanagement.PowerManagementCallback
import com.instabug.apm.webview.webview_trace.handler.WebViewTraceEventListener
import com.instabug.library.factory.Factory
import com.instabug.library.factory.ParameterizedFactory

class UiTraceWrapper(
    val cacheModel: UiTraceCacheModel,
    val webViewTraceListener: WebViewTraceEventListener?,
    var powerManagementCallback: PowerManagementCallback,
    var uiHangsHandler: UiHangHandler
)

class UiTraceWrapperFactory(
    private val webViewTraceListenerFactory: ParameterizedFactory<WebViewTraceEventListener?, Long>?,
    private val powerManagementCallbackFactory: ParameterizedFactory<UiTracePowerManagementCallback, UiTraceCacheModel>,
    private val uiHangsHandlerFactory: Factory<UiHangHandler>
) : ParameterizedFactory<UiTraceWrapper, Long> {
    override fun create(type: Long): UiTraceWrapper = UiTraceCacheModel()
        .apply { id = type }
        .let {
            UiTraceWrapper(
                it,
                webViewTraceListenerFactory?.create(it.id),
                powerManagementCallbackFactory.create(it),
                uiHangsHandlerFactory.create()
            )
        }
}