package com.instabug.apm.uitrace

import com.instabug.apm.cache.model.UiTraceCacheModel
import com.instabug.apm.util.powermanagement.PowerManagementCallback
import com.instabug.library.factory.ParameterizedFactory

class UiTracePowerManagementCallback(val model: UiTraceCacheModel) :
    PowerManagementCallback {

    override fun onBatteryLevelChanged(level: Int) {
        model.apply {
            batteryLevel = if (batteryLevel == -1) level else Math.min(level, batteryLevel)
        }
    }

    override fun onPowerSaveModeChanged(enabled: Boolean) {
        model.apply { if (enabled) powerSaveMode = true }
    }
}

class UiTracePowerManagementCallbackFactory :
    ParameterizedFactory<UiTracePowerManagementCallback, UiTraceCacheModel> {
    override fun create(type: UiTraceCacheModel): UiTracePowerManagementCallback =
        UiTracePowerManagementCallback(type)
}