package com.instabug.apm.sanitization

interface Sanitizer<T> {
    fun sanitize(item: T): T?
}

class CompositeSanitizer<T> : Sanitizer<T> {

    private val sanitizers: MutableList<Sanitizer<T>> = mutableListOf()

    fun addSanitizer(sanitizer: Sanitizer<T>?) {
        sanitizer?.let(sanitizers::add)
    }

    override fun sanitize(item: T): T? {
        var sanitizedItem: T? = item
        for (sanitization in sanitizers) sanitizedItem?.let {
            sanitizedItem = sanitization.sanitize(it)
        } ?: break
        return sanitizedItem
    }
}