package com.instabug.apm.networking.mapping.uiloading;

import androidx.annotation.Nullable;

import com.instabug.apm.cache.model.UiLoadingModel;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Serialize {@link UiLoadingModel} to JSON objects/ arrays
 */
public interface UiLoadingMapper {

    /**
     * Serialize an object of {@link UiLoadingModel} to a JSON object
     * @param model UiLoadingModel to be serialized
     * @return Serialized JsonObject of UiLoadingModel
     * @throws JSONException if serializing failed
     */
    @Nullable
    JSONObject toJson(@Nullable UiLoadingModel model) throws JSONException;
}
