package com.instabug.apm.networking.mapping.sessions;

import androidx.annotation.NonNull;

import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.library.model.v3Session.IBGSessionData;

import org.json.JSONArray;
import org.json.JSONException;

import java.util.List;
import java.util.Map;

public interface SessionMapper {

    /**
     * Serializes list of @{@link SessionCacheModel} to @{@link JSONArray}
     *
     * @param sessions list of apm sessions to be serialized
     * @return Json array of serialized apm network logs
     * @throws JSONException when serialization fails
     */

    @NonNull
    JSONArray toJsonArray(@NonNull List<SessionCacheModel> sessions) throws JSONException;

    /**
     * mapping list of @{@link SessionCacheModel} to map of @{@link IBGSessionData}
     *
     * @param sessions list of apm sessions to be mapped
     * @return map of sessions ids linked to sessions data
     * @throws JSONException when serialization fails
     */

    @NonNull
    Map<String, IBGSessionData> toSessionData(@NonNull List<SessionCacheModel> sessions) throws JSONException;

}
