package com.instabug.apm.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.networkv2.BodyBufferHelper;

import java.util.Map;

import kotlin.UInt;

/**
 * Internal APM Network Log Model
 */
public class DefaultAPMNetworkLog implements APMNetworkLog {
    private final static long MAX_U_INT_VALUE = 4294967295L;
    private long id = -1;
    @Nullable
    private Long startTime;
    @Nullable
    private String url;

    @Nullable
    private String method;
    @Nullable
    private String requestHeaders;
    @Nullable
    private String responseHeaders;
    @Nullable
    private String requestContentType;
    @Nullable
    private String responseContentType;
    @Nullable
    private String errorMessage;
    @Nullable
    private String radio;
    @Nullable
    private String Carrier;
    @Nullable
    private String graphQlQueryName;
    @Nullable
    private String grpcMethodName;
    @Nullable
    private String serverSideErrorMessage;
    private int clientErrorCode;
    private long totalDuration;
    private int responseCode;
    private long requestBodySize;
    private long responseBodySize;
    private boolean executedInBackground;

    @Nullable
    private String requestBody;
    @Nullable
    private String responseBody;

    @Nullable
    private String sessionId;

    private boolean isModified = false;

    @Nullable
    private Map<String, String> attributes = null;

    @Nullable
    private String latencySpansJsonString = null;

    @Nullable
    private Long externalTraceId = null;

    @Nullable
    private Long externalTraceStartTimestampMillis = null;

    @Nullable
    private Boolean isW3CTraceIdCaptured = null;
    @Nullable
    private Long generatedW3CPid = null;
    @Nullable
    private Long generatedW3CTimestampSeconds = null;
    @Nullable
    private String fullyGeneratedW3CTraceId = null;
    @Nullable
    private String syncableGeneratedW3CTraceId = null;
    @Nullable
    private String syncableCapturedW3CTraceId = null;

    @Override
    public long getId() {
        return id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    @Override
    public Long getStartTime() {
        return startTime;
    }

    @Override
    public void setStartTime(@Nullable Long startTime) {
        this.startTime = startTime;
    }

    @Nullable
    @Override
    public String getUrl() {
        return url;
    }

    @Override
    public void setUrl(@Nullable String url) {
        this.url = url;
    }

    @Nullable
    @Override
    public String getMethod() {
        return method;
    }

    @Override
    public void setMethod(@Nullable String method) {
        this.method = method;
    }

    @Override
    public int getResponseCode() {
        return responseCode;
    }

    @Override
    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Nullable
    @Override
    public String getRequestHeaders() {
        return requestHeaders;
    }

    @Override
    public void setRequestHeaders(@Nullable String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Nullable
    @Override
    public String getResponseHeaders() {
        return responseHeaders;
    }

    @Override
    public void setResponseHeaders(@Nullable String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    @Nullable
    @Override
    public String getRequestContentType() {
        return requestContentType;
    }

    @Override
    public void setRequestContentType(@Nullable String requestContentType) {
        this.requestContentType = requestContentType;
    }

    @Nullable
    @Override
    public String getResponseContentType() {
        return responseContentType;
    }

    @Override
    public void setResponseContentType(@Nullable String responseContentType) {
        this.responseContentType = responseContentType;
    }

    @Override
    public long getTotalDuration() {
        return totalDuration;
    }

    @Override
    public void setTotalDuration(long totalDuration) {
        if (totalDuration > this.totalDuration)
            this.totalDuration = totalDuration;
    }

    @Nullable
    @Override
    public String getErrorMessage() {
        return errorMessage;
    }

    @Override
    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Nullable
    @Override
    public String getRequestBody() {
        return requestBody;
    }

    @Override
    public long getRequestBodySize() {
        return requestBodySize;
    }

    @Override
    public void setRequestBodySize(long requestBodySize) {
        this.requestBodySize = requestBodySize;
    }

    @Override
    public long getResponseBodySize() {
        return responseBodySize;
    }

    @Override
    public void setResponseBodySize(long responseBodySize) {
        this.responseBodySize = responseBodySize;
    }

    @Nullable
    @Override
    public String getResponseBody() {
        return responseBody;
    }

    @Nullable
    @Override
    public String getRadio() {
        return radio;
    }

    @Override
    public void setRadio(@Nullable String radio) {
        this.radio = radio;
    }

    @Nullable
    @Override
    public String getCarrier() {
        return Carrier;
    }

    @Override
    public void setCarrier(@Nullable String carrier) {
        Carrier = carrier;
    }

    @Override
    public boolean getExecutedInBackground() {
        return executedInBackground;
    }

    @Override
    public void setExecutedInBackground(boolean executedInBackground) {
        this.executedInBackground = executedInBackground;
    }

    @Override
    public void setRequestBody(@Nullable String requestBody) {
        if (requestBody != null)
            this.requestBody = BodyBufferHelper.isBodySizeAllowed(requestBody) ? requestBody : BodyBufferHelper.MAX_SIZE_ALERT;
    }

    @Override
    public void setResponseBody(@Nullable String responseBody) {
        if (responseBody != null)
            this.responseBody = BodyBufferHelper.isBodySizeAllowed(responseBody) ? responseBody : BodyBufferHelper.MAX_SIZE_ALERT;
    }

    @Nullable
    @Override
    public String getGraphQlQueryName() {
        return graphQlQueryName;
    }

    @Override
    public void setGraphQlQueryName(@Nullable String graphQlQueryName) {
        this.graphQlQueryName = graphQlQueryName;
    }

    @Nullable
    @Override
    public String getServerSideErrorMessage() {
        return serverSideErrorMessage;
    }

    @Override
    public void setServerSideErrorMessage(@Nullable String serverSideErrorMessage) {
        this.serverSideErrorMessage = serverSideErrorMessage;
    }

    @NonNull
    @Override
    public String toString() {
        return "APMNetworkLog{" +
                "startTime=" + startTime +
                ", url='" + url + '\'' +
                ", method='" + method + '\'' +
                ", requestHeaders='" + requestHeaders + '\'' +
                ", responseHeaders='" + responseHeaders + '\'' +
                ", requestContentType='" + requestContentType + '\'' +
                ", responseContentType='" + responseContentType + '\'' +
                ", errorMessage='" + errorMessage + '\'' +
                ", totalDuration=" + totalDuration +
                ", responseCode=" + responseCode +
                ", requestBodySize=" + requestBodySize +
                ", responseBodySize=" + responseBodySize +
                ", requestBody='" + requestBody + '\'' +
                ", responseBody='" + responseBody + '\'' +
                ", sessionId= " + sessionId +
                '}';
    }

    @Nullable
    @Override
    public String getGrpcMethodName() {
        return grpcMethodName;
    }

    @Override
    public void setGrpcMethodName(@Nullable String grpcMethodName) {
        this.grpcMethodName = grpcMethodName;
    }

    @Override
    public int getClientErrorCode() {
        return clientErrorCode;
    }

    @Override
    public void setClientErrorCode(int clientErrorCode) {
        this.clientErrorCode = clientErrorCode;
    }

    @Override
    public void setSessionId(@Nullable String sessionId) {
        this.sessionId = sessionId;
    }

    @Nullable
    @Override
    public String getSessionId() {
        return sessionId;
    }

    @Override
    public boolean isModified() {
        return isModified;
    }

    @Override
    public void setModified(boolean isModified) {
        this.isModified = isModified;
    }

    @Nullable
    @Override
    public Map<String, String> getAttributes() {
        return attributes;
    }

    @Override
    public void setAttributes(@Nullable Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Nullable
    @Override
    public String getLatencySpansJsonString() {
        return latencySpansJsonString;
    }

    @Override
    public void setLatencySpansJsonString(@Nullable String latencySpansJsonString) {
        this.latencySpansJsonString = latencySpansJsonString;
    }

    @Override
    public boolean isValid() {
        return url != null && !url.trim().isEmpty();
    }

    @Nullable
    @Override
    public Long getExternalTraceId() {
        return externalTraceId;
    }

    /**
     * Added constraint to restrict storage of values outside the range of kotlin UInt.<br>
     * Maximum UInt value is 4294967295.
     */
    @Override
    public void setExternalTraceId(@Nullable Long externalTraceId) {
        if (externalTraceId == null) {
            this.externalTraceId = externalTraceId;
        } else if (externalTraceId >= 0 && externalTraceId <= MAX_U_INT_VALUE) {
            this.externalTraceId = externalTraceId;
        } else {
            this.externalTraceId = null;
        }
    }

    @Nullable
    @Override
    public Long getExternalTraceStartTimestampMillis() {
        return externalTraceStartTimestampMillis;
    }

    @Override
    public void setExternalTraceStartTimestampMillis(@Nullable Long externalTraceStartTime) {
        this.externalTraceStartTimestampMillis = externalTraceStartTime;
    }

    @Nullable
    @Override
    public Boolean isW3CTraceIdCaptured() {
        return isW3CTraceIdCaptured;
    }

    @Override
    public void setW3CTraceIdCaptured(@Nullable Boolean isCaptured) {
        isW3CTraceIdCaptured = isCaptured;
    }

    @Nullable
    @Override
    public Long getGeneratedW3CPid() {
        return generatedW3CPid;
    }

    @Override
    public void setGeneratedW3CPid(@Nullable Long generatedPid) {
        generatedW3CPid = generatedPid;
    }

    @Nullable
    @Override
    public Long getGeneratedW3CTimestampSeconds() {
        return generatedW3CTimestampSeconds;
    }

    @Nullable
    @Override
    public String getFullyGeneratedW3CTraceId() {
        return fullyGeneratedW3CTraceId;
    }

    @Override
    public void setFullyGeneratedW3CTraceId(@Nullable String traceId) {
        fullyGeneratedW3CTraceId = traceId;
    }

    @Override
    public void setGeneratedW3CTimestampSeconds(@Nullable Long timestampSeconds) {
        generatedW3CTimestampSeconds = timestampSeconds;
    }

    @Nullable
    @Override
    public String getSyncableGeneratedW3CTraceId() {
        return syncableGeneratedW3CTraceId;
    }

    @Override
    public void setSyncableGeneratedW3CTraceId(@Nullable String traceId) {
        syncableGeneratedW3CTraceId = traceId;
    }

    @Nullable
    @Override
    public String getSyncableCapturedW3CTraceId() {
        return syncableCapturedW3CTraceId;
    }

    @Override
    public void setSyncableCapturedW3CTraceId(@Nullable String traceId) {
        syncableCapturedW3CTraceId = traceId;
    }
}