package com.instabug.apm.handler.session;

import android.annotation.SuppressLint;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.configuration.APMConfigurationProvider;
import com.instabug.apm.constants.Constants;
import com.instabug.apm.di.ServiceLocator;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;

/**
 * Detects APM crashing sessions
 */
public class APMUncaughtExceptionHandler implements Thread.UncaughtExceptionHandler {

    @Nullable
    private Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private APMConfigurationProvider apmConfigurationProvider = ServiceLocator.getApmConfigurationProvider();
    private SessionHandler sessionHandler = ServiceLocator.getSessionHandler();

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public APMUncaughtExceptionHandler() {
        defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {

        if (apmConfigurationProvider.isCrashDetectionEnabled()) {
            SettingsManager.getInstance().setCrashedSession(true);
            InstabugSDKLogger.d(Constants.LOG_TAG, "ending APM session");
            sessionHandler.endSession(Constants.SessionEndStatusCode.CRASHING_SESSION);
        }

        if(defaultUncaughtExceptionHandler != null) {
            defaultUncaughtExceptionHandler.uncaughtException(thread, throwable);
        }

    }
}
