package com.instabug.apm.di

import com.instabug.apm.model.APMNetworkLog
import com.instabug.apm.networkinterception.sanitization.InterceptorType
import com.instabug.apm.sanitization.Sanitizer

object InterceptorsServiceLocator {

    @JvmStatic
    val okHttpSanitizer: Sanitizer<APMNetworkLog>
        get() = ServiceLocator.getNetworkInterceptionSanitizer(InterceptorType.OK_HTTP)

    @JvmStatic
    val httpUrlConnectionSanitizer: Sanitizer<APMNetworkLog>
        get() = ServiceLocator.getNetworkInterceptionSanitizer(InterceptorType.HTTP_URL_CONNECTION)

    @JvmStatic
    val grpcSanitizer: Sanitizer<APMNetworkLog>
        get() = ServiceLocator.getNetworkInterceptionSanitizer(InterceptorType.GRPC)

    @JvmStatic
    val apmNetworkLoggerSanitizer: Sanitizer<APMNetworkLog>
        get() = ServiceLocator.getNetworkInterceptionSanitizer(InterceptorType.APM_NETWORK_LOGGER)

    @JvmStatic
    val apmServiceLocatorLock: Class<ServiceLocator>
        get() = ServiceLocator::class.java

    @JvmStatic
    fun postNetworkLoggingTask(runnable: Runnable) = ServiceLocator.postNetworkLoggingTask(runnable)
}